/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtFileListener;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtFileManager {
    private final Project myProject;
    private final LinkedHashMap<VirtualFile, JsbtFileStructure> myBuildfiles;
    private final List<JsbtFileListener> myListeners;
    private final JsbtService myService;
    private boolean myDetectionDone;
    private VirtualFileListener myVirtualFileListener;
    private JsbtSortingMode mySortingMode;

    public JsbtFileManager(@NotNull Project project, @NotNull JsbtService service) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "<init>"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "<init>"));
        }
        this.myBuildfiles = ContainerUtil.newLinkedHashMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDetectionDone = false;
        this.mySortingMode = JsbtSortingMode.DEFINITION_ORDER;
        this.myProject = project;
        this.myService = service;
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                JsbtFileManager.this.myListeners.clear();
                JsbtFileManager.this.myBuildfiles.clear();
                JsbtFileManager.this.removeVirtualFileListener();
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "getProject"));
        }
        return project;
    }

    public boolean isDetectionDone() {
        return this.myDetectionDone;
    }

    public void setDetectionDone() {
        this.myDetectionDone = true;
    }

    public final void fetchStructure(@NotNull VirtualFile buildfile, @NotNull CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException> consumer) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "fetchStructure"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "fetchStructure"));
        }
        if (this.shouldSaveAllDocumentBeforeFetch()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (buildfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "lambda$fetchStructure$2"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "lambda$fetchStructure$2"));
            }
            try {
                JsbtFileStructure structure = this.myService.fetchBuildfileStructure(this.myProject, buildfile);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (buildfile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "lambda$null$0"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "lambda$null$0"));
                    }
                    this.myBuildfiles.put(buildfile, structure);
                    consumer.consume((Object)structure);
                }, ModalityState.any(), this.myProject.getDisposed());
            }
            catch (JsbtTaskFetchException e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (buildfile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "lambda$null$1"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "lambda$null$1"));
                    }
                    this.myBuildfiles.put(buildfile, null);
                    consumer.consume((Throwable)e);
                }, ModalityState.any(), this.myProject.getDisposed());
            }
        });
    }

    protected boolean shouldSaveAllDocumentBeforeFetch() {
        return true;
    }

    public void clearAllBuildfiles() {
        this.myBuildfiles.clear();
        this.removeVirtualFileListener();
    }

    public void addBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "addBuildfile"));
        }
        this.myDetectionDone = true;
        if (this.myBuildfiles.containsKey(file)) {
            this.fireBuildfileSelected(file);
        } else {
            this.myBuildfiles.put(file, null);
            this.fireBuildfileAdded(file);
            this.ensureVirtualFileListenerAdded();
        }
    }

    private void ensureVirtualFileListenerAdded() {
        if (this.myVirtualFileListener == null) {
            this.myVirtualFileListener = new MyVirtualFileListener();
            VirtualFileManager.getInstance().addVirtualFileListener(this.myVirtualFileListener);
        }
    }

    private void removeVirtualFileListener() {
        if (this.myVirtualFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
            this.myVirtualFileListener = null;
        }
    }

    protected void addBuildfileStructure(@NotNull JsbtFileStructure structure) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "addBuildfileStructure"));
        }
        this.myBuildfiles.put(structure.getBuildfile(), structure);
        this.ensureVirtualFileListenerAdded();
    }

    @Nullable
    public JsbtFileStructure getCachedStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "getCachedStructure"));
        }
        return this.myBuildfiles.get(buildfile);
    }

    public void removeBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "removeBuildfile"));
        }
        if (this.myBuildfiles.containsKey(file)) {
            this.myBuildfiles.remove(file);
            this.fireBuildfileRemoved(file);
            if (this.myBuildfiles.isEmpty()) {
                this.removeVirtualFileListener();
            }
        }
    }

    public boolean containsBuildfile(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "containsBuildfile"));
        }
        return this.myBuildfiles.containsKey(buildfile);
    }

    @NotNull
    public Collection<VirtualFile> getBuildfiles() {
        Set<VirtualFile> set = this.myBuildfiles.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "getBuildfiles"));
        }
        return set;
    }

    public boolean hasBuildfiles() {
        return !this.myBuildfiles.isEmpty();
    }

    public void addListener(final @NotNull JsbtFileListener listener, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "addListener"));
        }
        this.myListeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    JsbtFileManager.this.myListeners.remove(listener);
                }
            });
        }
    }

    public void removeListener(@NotNull JsbtFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    private void fireBuildfileAdded(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "fireBuildfileAdded"));
        }
        for (JsbtFileListener listener : this.myListeners) {
            listener.onBuildfileAdded(buildfile);
        }
    }

    private void fireBuildfileSelected(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "fireBuildfileSelected"));
        }
        for (JsbtFileListener listener : this.myListeners) {
            listener.onBuildfileSelected(buildfile);
        }
    }

    private void fireBuildfileRemoved(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "fireBuildfileRemoved"));
        }
        for (JsbtFileListener listener : this.myListeners) {
            listener.onBuildfileRemoved(buildfile);
        }
    }

    @NotNull
    public JsbtSortingMode getSortingMode() {
        JsbtSortingMode jsbtSortingMode = this.mySortingMode;
        if (jsbtSortingMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "getSortingMode"));
        }
        return jsbtSortingMode;
    }

    public void setSortingMode(@NotNull JsbtSortingMode sortingMode) {
        if (sortingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortingMode", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "setSortingMode"));
        }
        JsbtSortingMode oldSortingMode = this.mySortingMode;
        this.mySortingMode = sortingMode;
        if (oldSortingMode != sortingMode) {
            for (JsbtFileListener listener : this.myListeners) {
                listener.onSortingModeChanged(sortingMode);
            }
        }
    }

    public void changeBuildfile(@NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
        if (oldBuildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBuildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "changeBuildfile"));
        }
        if (newBuildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBuildfile", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager", "changeBuildfile"));
        }
        if (this.myBuildfiles.containsKey(oldBuildfile)) {
            this.myBuildfiles.remove(oldBuildfile);
            this.myBuildfiles.put(newBuildfile, null);
            for (JsbtFileListener listener : this.myListeners) {
                listener.onBuildfileChanged(oldBuildfile, newBuildfile);
            }
        }
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/JsbtFileManager$MyVirtualFileListener", "beforeFileDeletion"));
            }
            VirtualFile file = event.getFile();
            if (file.isDirectory()) {
                if (JsbtFileManager.this.myProject.isDisposed()) {
                    return;
                }
                ProjectFileIndex.getInstance((Project)JsbtFileManager.this.myProject).iterateContentUnderDirectory(file, descendant -> {
                    if (!descendant.isDirectory() && JsbtFileManager.this.myBuildfiles.containsKey(descendant)) {
                        JsbtFileManager.this.removeBuildfile(descendant);
                    }
                    return !JsbtFileManager.this.myProject.isDisposed();
                });
            } else if (JsbtFileManager.this.myBuildfiles.containsKey(file)) {
                JsbtFileManager.this.removeBuildfile(file);
            }
        }
    }
}

