/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GruntTask {
    private final GruntfileStructure myStructure;
    private final String myName;
    private final String myInfo;
    private final String myFilePath;
    private final boolean myMulti;

    protected GruntTask(@NotNull GruntfileStructure structure, @NotNull String name, @Nullable String info, @Nullable String filePath, boolean multi) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "<init>"));
        }
        this.myStructure = structure;
        this.myName = name;
        this.myInfo = info;
        this.myFilePath = filePath != null ? FileUtil.toSystemIndependentName((String)filePath) : null;
        this.myMulti = multi;
    }

    @NotNull
    public GruntfileStructure getStructure() {
        GruntfileStructure gruntfileStructure = this.myStructure;
        if (gruntfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "getStructure"));
        }
        return gruntfileStructure;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "getName"));
        }
        return string;
    }

    @Nullable
    public String getInfo() {
        return this.myInfo;
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    public boolean isMulti() {
        return this.myMulti;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GruntTask task = (GruntTask)o;
        return this.myName.equals(task.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Nullable
    public static GruntTask getUserObject(@Nullable DefaultMutableTreeNode node) {
        return JsbtTree.getUserObject(node, GruntTask.class);
    }

    @NotNull
    public static Collection<GruntTask> listAllDependentTasksFor(@NotNull GruntTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "listAllDependentTasksFor"));
        }
        HashSet visitedTasks = ContainerUtil.newHashSet();
        GruntTask.listAllDependentTasksFor(task, visitedTasks);
        HashSet hashSet = visitedTasks;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "listAllDependentTasksFor"));
        }
        return hashSet;
    }

    private static void listAllDependentTasksFor(@NotNull GruntTask task, @NotNull Set<GruntTask> visitedTasks) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "listAllDependentTasksFor"));
        }
        if (visitedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedTasks", "com/intellij/lang/javascript/buildTools/grunt/GruntTask", "listAllDependentTasksFor"));
        }
        if (!visitedTasks.contains(task)) {
            visitedTasks.add(task);
            if (task instanceof GruntAliasTask) {
                ImmutableList<String> deps = ((GruntAliasTask)task).getDependencies();
                for (String dep : deps) {
                    GruntTask depTask = task.getStructure().findTaskByName(dep);
                    if (depTask == null) continue;
                    GruntTask.listAllDependentTasksFor(depTask, visitedTasks);
                }
            }
        }
    }
}

