/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.google.gson.Gson;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfig;
import com.intellij.lang.javascript.buildTools.webpack.WebPackNotifier;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExecutor;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "notifier", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackNotifier;", "getNotifier", "()Lcom/intellij/lang/javascript/buildTools/webpack/WebPackNotifier;", "loadConfig", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfig;", "project", "Lcom/intellij/openapi/project/Project;", "configPath", "", "run", "Lcom/intellij/execution/process/ProcessOutput;", "path", "JavaScriptLanguage"})
public final class WebPackExecutor {
    @NotNull
    private final WebPackNotifier notifier = new WebPackNotifier();
    @NotNull
    private final Logger logger = Logger.getInstance((String)"#com.intellij.lang.javascript.buildTools.webpack.WebPackExecutor");

    @NotNull
    public final WebPackNotifier getNotifier() {
        return this.notifier;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ProcessOutput run(@NotNull Project project, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
        if (nodeJsInterpreter == null) {
            return null;
        }
        NodeJsInterpreter node = nodeJsInterpreter;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(node);
        if (!(localInterpreter != null && localInterpreter.isValid() || (localInterpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant()) != null)) {
            String string = "Failed to load " + PathUtil.getFileName((String)path);
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
            this.notifier.notify(project, string, messageType, new AnAction(project, "Set up node.js interpreter"){
                final /* synthetic */ Project $project;

                public void actionPerformed(@Nullable AnActionEvent e) {
                    NodeJSSettingsManager.editSettingsAppropriately(this.$project);
                }
                {
                    this.$project = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
            return null;
        }
        Map map = commandLine.getEnvironment();
        CharSequence charSequence = "NODE_ENV";
        String string = "development";
        map.put(charSequence, string);
        commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
        commandLine.setWorkDirectory(VfsUtil.virtualToIoFile((VirtualFile)project.getBaseDir()));
        commandLine.addParameter("-e");
        String loader = "";
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)".babel.", (boolean)false, (int)2, null)) {
            loader = "require('babel-register');";
        } else if (StringsKt.endsWith$default((String)path, (String)".ts", (boolean)false, (int)2, null)) {
            loader = "require('ts-node/register');";
        }
        charSequence = loader;
        StringBuilder stringBuilder = new StringBuilder().append("\n      ").append(loader).append("\n      var config = require('").append(path).append("');\n      if (");
        GeneralCommandLine generalCommandLine = commandLine;
        boolean bl = charSequence.length() > 0;
        generalCommandLine.addParameter(StringsKt.trimIndent((String)stringBuilder.append(bl).append(" && config.default !== undefined) config = config.default;\n      if (typeof(config) === 'function') config = config({});\n      console.log(JSON.stringify(config))\n      ").toString()));
        return NodeCommandLineUtil.execute(commandLine, 10000L);
    }

    @NotNull
    public final WebPackConfig loadConfig(@NotNull Project project, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        ProcessOutput run2 = this.run(project, configPath);
        if (run2 != null && run2.getExitCode() == 0) {
            String string;
            String string2;
            String string3 = string2 = run2.getStdout();
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String stdOut = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            int lastNewLine = StringsKt.lastIndexOf$default((CharSequence)stdOut, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (lastNewLine > 0) {
                String string4 = stdOut;
                int n = lastNewLine + 1;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = stdOut;
            }
            String result = string;
            try {
                WebPackConfig config2 = (WebPackConfig)new Gson().fromJson(result, WebPackConfig.class);
                String string7 = "" + PathUtil.getFileName((String)configPath) + " successfully loaded";
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
                WebPackNotifier.notify$default(this.notifier, project, string7, messageType, null, 8, null);
                WebPackConfig webPackConfig = config2;
                Intrinsics.checkExpressionValueIsNotNull((Object)webPackConfig, (String)"config");
                return webPackConfig;
            }
            catch (RuntimeException e) {
                this.logger.debug(e.getMessage(), (Throwable)e);
                String string8 = "Failed to load " + PathUtil.getFileName((String)configPath);
                MessageType messageType = MessageType.WARNING;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
                WebPackNotifier.notify$default(this.notifier, project, string8, messageType, null, 8, null);
            }
        } else if (run2 != null) {
            String string = "Failed to load " + PathUtil.getFileName((String)configPath);
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
            WebPackNotifier.notify$default(this.notifier, project, string, messageType, null, 8, null);
            this.logger.warn("failed to evaluate webpack config. exit code: " + run2.getExitCode() + "" + (run2.isTimeout() ? ", timed out" : ""));
        }
        return new WebPackConfig(null, 1, null);
    }
}

