/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSignatureChooser {
    private static final Comparator<PsiElement> FUNCTIONS_FIRST = Comparator.comparing(el -> el instanceof JSFunction ? -1 : 0).thenComparing(el -> el instanceof JSVariable ? -1 : 0).thenComparing(el -> el instanceof TypeScriptInterface || el instanceof TypeScriptTypeAlias ? 1 : -1);

    @NotNull
    public static JSResolveResult checkParameterTypes(@NotNull PsiElement candidate, @Nullable List<JSType> argumentTypes, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
        }
        JSResolveResult jSResolveResult = TypeScriptSignatureChooser.checkParameterTypes(candidate, argumentTypes, genericArguments, isNewExpression, null);
        if (jSResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
        }
        return jSResolveResult;
    }

    @NotNull
    private static JSResolveResult checkParameterTypes(@NotNull PsiElement candidate, @Nullable List<JSType> argumentTypes, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression, @Nullable Collection<PsiElement> visited) {
        JSResolveResult overloadResult;
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
        }
        if (candidate instanceof ES6ImportSpecifier) {
            ResolveResult[] results = ((ES6ImportSpecifier)candidate).multiResolve(false);
            ArrayList elements = ContainerUtil.newArrayList(JSResolveResult.toElements(results, true));
            if (elements.isEmpty()) {
                JSResolveResult jSResolveResult = new JSResolveResult(candidate);
                if (jSResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
                }
                return jSResolveResult;
            }
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            if (!visited.add(candidate)) {
                JSResolveResult jSResolveResult = new JSResolveResult(candidate);
                if (jSResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
                }
                return jSResolveResult;
            }
            ContainerUtil.sort((List)elements, FUNCTIONS_FIRST);
            for (PsiElement element : elements) {
                JSResolveResult result = TypeScriptSignatureChooser.checkParameterTypes(element, argumentTypes, genericArguments, isNewExpression, visited);
                if (!result.isValidResult()) continue;
                JSResolveResult jSResolveResult = result;
                if (jSResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
                }
                return jSResolveResult;
            }
        }
        if (!(candidate instanceof JSFunction)) {
            JSResolveResult jSResolveResult = new JSResolveResult(candidate);
            if (jSResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
            }
            return jSResolveResult;
        }
        if (candidate instanceof TypeScriptFunction && (overloadResult = TypeScriptSignatureChooser.getOverloadResultSignature(candidate, argumentTypes, genericArguments, isNewExpression)) != null) {
            JSResolveResult jSResolveResult = overloadResult;
            if (jSResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
            }
            return jSResolveResult;
        }
        JSFunction jsFunction = (JSFunction)candidate;
        JSParameterList parameterList = jsFunction.isConstructor() == isNewExpression ? jsFunction.getParameterList() : null;
        JSResolveResult jSResolveResult = new JSResolveResult(candidate, null, TypeScriptSignatureChooser.checkParameterTypes(argumentTypes, genericArguments, parameterList));
        if (jSResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
        }
        return jSResolveResult;
    }

    @Nullable
    private static JSResolveResult getOverloadResultSignature(@NotNull PsiElement functionCandidate, @Nullable List<JSType> argumentTypes, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression) {
        if (functionCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCandidate", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getOverloadResultSignature"));
        }
        List overloads = ((TypeScriptFunction)functionCandidate).getOverloadDeclarations();
        String firstError = null;
        TypeScriptFunction firstOverload = null;
        for (TypeScriptFunction overload : overloads) {
            if (overload.isConstructor() != isNewExpression) continue;
            String latestError = TypeScriptSignatureChooser.checkParameterTypes(argumentTypes, genericArguments, overload.getParameterList());
            if (latestError == null) {
                return new JSResolveResult((PsiElement)overload);
            }
            if (firstError != null) continue;
            firstError = latestError;
            firstOverload = overload;
        }
        if (TypeScriptSignatureChooser.isOverloadImplementation(functionCandidate)) {
            PsiElement resultFunction = functionCandidate;
            if (firstError != null) {
                resultFunction = firstOverload;
            }
            return new JSResolveResult(resultFunction, null, firstError);
        }
        return null;
    }

    public static boolean isOverloadImplementation(@Nullable PsiElement function) {
        return function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadImplementation();
    }

    @NotNull
    private static List<JSParameterTypeDecorator> getTypeDecoratorsWithAppliedGenerics(@NotNull JSParameterItem[] parameters, @Nullable JSTypeSubstitutor genericArguments) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getTypeDecoratorsWithAppliedGenerics"));
        }
        ArrayList<JSParameterTypeDecorator> parameterTypes = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterItem p : parameters) {
            JSType parameterType = p.getType();
            if (parameterType != null) {
                parameterType = JSTypeUtils.applyGenericArguments(parameterType, (Map<String, JSType>)genericArguments);
            }
            JSParameterTypeDecoratorImpl typeDecorator = new JSParameterTypeDecoratorImpl(parameterType, p.isOptional(), p.isRest(), p.getTypeDecorator().isExplicitlyDeclared());
            parameterTypes.add(typeDecorator);
        }
        ArrayList<JSParameterTypeDecorator> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getTypeDecoratorsWithAppliedGenerics"));
        }
        return arrayList;
    }

    @Nullable
    public static String checkParameterTypes(@Nullable List<JSType> argumentTypes, @Nullable JSTypeSubstitutor genericArguments, @Nullable JSParameterList parameterList) {
        if (parameterList == null) {
            return null;
        }
        List<JSParameterTypeDecorator> functionParameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics((JSParameterItem[])parameterList.getParameters(), genericArguments);
        return TypeScriptSignatureChooser.checkParameterTypes(argumentTypes, functionParameters);
    }

    @Nullable
    private static String checkParameterTypes(@Nullable List<JSType> argumentTypes, @NotNull List<JSParameterTypeDecorator> functionParameters) {
        if (functionParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionParameters", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "checkParameterTypes"));
        }
        ProcessingContext context = new ProcessingContext();
        context.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
        List<JSParameterTypeDecorator> arguments = JSTypeUtils.getParameterTypeDecorators(argumentTypes);
        return JSTypeUtils.areArgumentsAssignable(functionParameters, arguments, context, false, true, true) ? null : "javascript.argument.types.mismatch";
    }

    @Nullable
    public static JSFunction getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<JSFunction> functions) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionWithParameters"));
        }
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionWithParameters"));
        }
        return TypeScriptSignatureChooser.getFunctionWithParameters(expression, functions, null);
    }

    @Nullable
    public static <T extends JSFunctionItem> T getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<T> functions, @Nullable JSTypeSubstitutor substitutor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionWithParameters"));
        }
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionWithParameters"));
        }
        List<JSType> argumentTypes = JSTypeUtils.getArgumentTypes(expression.getArgumentList());
        for (JSFunctionItem constructor : functions) {
            List<JSParameterTypeDecorator> parameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics(constructor.getParameters(), substitutor);
            if (TypeScriptSignatureChooser.checkParameterTypes(argumentTypes, parameters) != null) continue;
            return (T)constructor;
        }
        return null;
    }

    @NotNull
    public static List<JSFunctionWithSubstitutor> getFunctionElementsWithCheckParameterTypes(@NotNull PsiElement referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionElementsWithCheckParameterTypes"));
        }
        if (referenceExpression instanceof JSReferenceExpression && referenceExpression.getParent() instanceof JSCallExpression) {
            PsiElement functionCandidate;
            List<JSFunctionItem> resolveElements;
            JSCallExpression callExpression = (JSCallExpression)referenceExpression.getParent();
            JSReferenceExpression element = (JSReferenceExpression)referenceExpression;
            ResolveResult[] resolveResults = element.multiResolve(false);
            Collection<PsiElement> elements = JSResolveResult.toElements(resolveResults);
            if (callExpression instanceof JSNewExpression && (resolveElements = TypeScriptSignatureChooser.getConstructorsForResolveElements((JSExpression)referenceExpression, elements)).size() > 0) {
                List<JSFunctionWithSubstitutor> list = resolveElements.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionElementsWithCheckParameterTypes"));
                }
                return list;
            }
            if (elements.size() == 1 && (functionCandidate = (PsiElement)ContainerUtil.getFirstItem(elements)) != null && !(functionCandidate instanceof JSFunction) && DialectDetector.isTypeScript(functionCandidate)) {
                List<JSFunctionWithSubstitutor> list = TypeScriptSignatureChooser.getCallSignatures(functionCandidate, callExpression);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionElementsWithCheckParameterTypes"));
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getFunctionElementsWithCheckParameterTypes"));
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionItem> getConstructorsForResolveElements(@NotNull JSExpression parent, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getConstructorsForResolveElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getConstructorsForResolveElements"));
        }
        if (!elements.isEmpty()) {
            List result = ContainerUtil.newSmartList();
            for (PsiElement psiElement : elements) {
                ResolveResult[] results;
                Collection<PsiElement> resolvedElements;
                if (!(psiElement instanceof JSClass) || (resolvedElements = JSResolveResult.toElements(results = JSClassUtils.resolveES6Constructor((JSClass)psiElement, parent))).isEmpty()) continue;
                result.addAll(resolvedElements);
            }
            if (result.size() > 0) {
                List list = ContainerUtil.mapNotNull((Collection)result, el -> el instanceof JSFunctionItem ? (JSFunctionItem)el : null);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getConstructorsForResolveElements"));
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getConstructorsForResolveElements"));
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull PsiElement functionCandidate, @NotNull JSCallExpression callExpression) {
        if (functionCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCandidate", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getCallSignatures"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getCallSignatures"));
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(functionCandidate, (PsiElement)callExpression, null);
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors = JSPsiImplUtils.calculatePossibleFunctions(functionCandidate, (PsiElement)callExpression);
        List functionItems = functionWithSubstitutors.stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
        Object functionItem = TypeScriptSignatureChooser.getFunctionWithParameters(callExpression, functionItems, substitutor);
        if (functionItem != null) {
            for (JSFunctionWithSubstitutor withSubstitutor : functionWithSubstitutors) {
                if (withSubstitutor.myFunctionItem != functionItem) continue;
                List list = ContainerUtil.createMaybeSingletonList((Object)withSubstitutor);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getCallSignatures"));
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser", "getCallSignatures"));
        }
        return list;
    }
}

