/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!file.isPhysical() || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        JSLiteralExpression literalExpression = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd);
        if (literalExpression == null) {
            return null;
        }
        return JSStringUtil.unescapeSimpleStringChars(text);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!file.isPhysical()) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        JSLiteralExpression literalExpression = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (literalExpression == null) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        boolean escapeWhitespace = !(literalExpression instanceof JSStringTemplateExpression);
        boolean splitAtNewLine = (rawText == null || rawText.rawText == null) && !(literalExpression instanceof JSStringTemplateExpression);
        String string = JSStringLiteralCopyPasteProcessor.getPastedText(text, literalExpression, splitAtNewLine, escapeWhitespace);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    @NotNull
    private static String getPastedText(String text, JSLiteralExpression literalExpression, boolean splitAtNewLine, boolean escapeWhitespace) {
        char quote = literalExpression.getText().charAt(0);
        if (!splitAtNewLine) {
            StringBuilder buffer = new StringBuilder();
            JSStringUtil.escapeSimpleStringChars(text, quote, escapeWhitespace, escapeWhitespace, false, buffer);
            String string = buffer.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "getPastedText"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String lineTail = JSStringLiteralCopyPasteProcessor.getTail(quote, (PsiElement)literalExpression);
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            JSStringUtil.escapeSimpleStringChars(line, quote, escapeWhitespace, escapeWhitespace, false, buffer);
            if (i == lines.length - 1) continue;
            buffer.append(lineTail);
        }
        if (text.endsWith("\n")) {
            buffer.append("\\n");
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "getPastedText"));
        }
        return string;
    }

    @Nullable
    private static JSLiteralExpression getSingleElementFromSelectionOrNull(@NotNull PsiFile file, int start, int end) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "getSingleElementFromSelectionOrNull"));
        }
        PsiElement element = file.findElementAt(start);
        JSLiteralExpression literalExpression = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSLiteralExpression.class);
        if (literalExpression == null || !literalExpression.isQuotedLiteral() || start <= literalExpression.getTextRange().getStartOffset() || end >= literalExpression.getTextRange().getEndOffset()) {
            return null;
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)literalExpression;
            TextRange[] ranges = templateExpression.getStringRanges();
            boolean containedInSingleRange = ranges.length == 0 || Arrays.stream(ranges).map(range -> range.shiftRight(templateExpression.getTextRange().getStartOffset())).anyMatch(range -> range.containsRange(start, end));
            return containedInSingleRange ? literalExpression : null;
        }
        return literalExpression;
    }

    @NotNull
    private static String getTail(char quote, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "getTail"));
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(context.getLanguage());
        String string = "\\n" + quote + (commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\n+" : "+\n") + quote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor", "getTail"));
        }
        return string;
    }
}

