/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JavaScriptGroupRuleProviderBase<T extends JSNamedElement>
implements FileStructureGroupRuleProvider {
    JavaScriptGroupRuleProviderBase() {
    }

    @Nullable
    public UsageGroupingRule getUsageGroupingRule(Project project) {
        return new SingleParentUsageGroupingRule(){

            @Nullable
            protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
                if (usage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/lang/javascript/findUsages/JavaScriptGroupRuleProviderBase$1", "getParentGroupFor"));
                }
                if (targets == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/lang/javascript/findUsages/JavaScriptGroupRuleProviderBase$1", "getParentGroupFor"));
                }
                if (usage instanceof PsiElementUsage) {
                    PsiElement psiElement = ((PsiElementUsage)usage).getElement();
                    if (!psiElement.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                        return null;
                    }
                    return JavaScriptGroupRuleProviderBase.this.createUsageGroupForElement(psiElement);
                }
                return null;
            }
        };
    }

    protected UsageGroup createUsageGroupForElement(PsiElement psiElement) {
        JSNamedElement element = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, this.getUsageClass());
        if (this.isAcceptableElement(element)) {
            return this.createUsageGroup(element);
        }
        return null;
    }

    protected boolean isAcceptableElement(JSNamedElement element) {
        return element != null;
    }

    protected abstract Class<? extends JSNamedElement> getUsageClass();

    protected abstract UsageGroup createUsageGroup(T var1);
}

