/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSErrorInspection;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowJSCoverageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flow/FlowJSCoverageInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                VirtualFile virtualFile;
                Document document;
                FlowJSServerService serverService = FlowJSServerManager.getService(file);
                if (serverService == null) {
                    return;
                }
                if (!FlowJSAnnotation.isFlowAnnotation(file)) {
                    return;
                }
                List<JSAnnotationError> errors = serverService.getCoverageOfFile(file);
                if (!errors.isEmpty() && (document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null && (virtualFile = file.getVirtualFile()) != null) {
                    FlowJSErrorInspection.reportErrors(errors, file, document, holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSCoverageInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

