/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPassFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.FixedFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServiceHighlightingPassFactory
extends JSLanguageServiceHighlightingPassFactory {
    private static final JSLanguageService DUMMY_SERVICE = new JSLanguageService(){

        @Override
        @NotNull
        public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile file, @NotNull JSFileHighlightingInfo info) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory$1", "highlight"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory$1", "highlight"));
            }
            FixedFuture fixedFuture = new FixedFuture(Collections.emptyList());
            if (fixedFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory$1", "highlight"));
            }
            return fixedFuture;
        }

        @Override
        public boolean canHighlight(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory$1", "canHighlight"));
            }
            return true;
        }

        @Override
        @NotNull
        public Condition<VirtualFile> getAcceptableFilesFilter() {
            Condition<VirtualFile> condition = FlowJSServerService.FILES_TO_PROCESS;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory$1", "getAcceptableFilesFilter"));
            }
            return condition;
        }
    };

    public FlowJSServiceHighlightingPassFactory(Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        if (highlightingPassRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingPassRegistrar", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory", "<init>"));
        }
        super(project, highlightingPassRegistrar);
    }

    @Override
    @Nullable
    protected JSLanguageService getService(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServiceHighlightingPassFactory", "getService"));
        }
        FlowJSServerService service = FlowJSServerManager.getService(file);
        return service != null ? service : DUMMY_SERVICE;
    }
}

