/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixes;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.JSReplaceImplementsExtendsKeyword;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.AssignParameterToFieldAction;
import com.intellij.lang.javascript.inspections.CreateFieldFromParameterAction;
import com.intellij.lang.javascript.inspections.DownloadLibraryQuickFix;
import com.intellij.lang.javascript.inspections.ES6CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.inspections.JSMoveToScopeStartIntentionAction;
import com.intellij.lang.javascript.inspections.JSRemoveElementLocalQuickFix;
import com.intellij.lang.javascript.inspections.JSSuppressByCommentFix;
import com.intellij.lang.javascript.intentions.TypeScriptChangeES6ImportIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.AddConstructorAndSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.AddSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.ChangeTypeFix;
import com.intellij.lang.javascript.validation.fixes.CreateInheritanceFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionFromArgumentIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSNamespaceIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSParameterIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSInsertCastFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertModifierFix;
import com.intellij.lang.javascript.validation.fixes.JSSetElementVisibilityFix;
import com.intellij.lang.javascript.validation.fixes.MakeMethodStaticFix;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.lang.javascript.validation.fixes.RenameReferenceFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMethodsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptInsertTypeGuardFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddFileToConfigFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.intentions.TypeScriptDisableConfigFix;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidatorImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.fix.RenameFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSFixFactoryImpl
extends JSFixFactory {
    @Override
    public LocalQuickFix changeTypeFix(JSNamedElement var, String expressionType, String nameKey) {
        return new ChangeTypeFix(var, expressionType, nameKey);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction function, Function<JSParameter, String> typeProvider, String overriddenReturnType) {
        List<JSParameterInfo> paramInfos = JSMethodDescriptor.getParameters(function, typeProvider);
        JSFunction top = JSInheritanceUtil.findTopMethods(function).iterator().next();
        ChangeSignatureFix fix = new ChangeSignatureFix(top, paramInfos);
        fix.setOverriddenReturnType(overriddenReturnType);
        return fix;
    }

    @Override
    public LocalQuickFix createInheritanceFix(JSClass expectedClass, PsiElement actualClass) {
        return new CreateInheritanceFix(actualClass, expectedClass.getQualifiedName(), expectedClass.isInterface());
    }

    @Override
    public LocalQuickFix jsInsertCastFix(String type, @NotNull DialectOptionHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "jsInsertCastFix"));
        }
        return new JSInsertCastFix(type, holder);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement removeASTNodeFix(@NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String propKey, boolean fixNewLines, @NotNull ASTNode startNode, @NotNull ASTNode endNode) {
        if (propKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propKey", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "removeASTNodeFix"));
        }
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNode", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "removeASTNodeFix"));
        }
        if (endNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endNode", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "removeASTNodeFix"));
        }
        return new RemoveASTNodeFix(propKey, fixNewLines, startNode, endNode);
    }

    @Override
    public LocalQuickFix renameReferenceFix() {
        return new RenameReferenceFix();
    }

    @Override
    public LocalQuickFix createJSVariableIntentionAction(String name, boolean field, boolean constant) {
        return new CreateJSVariableIntentionAction(name, field, constant);
    }

    @Override
    public LocalQuickFix createJSParameterIntentionAction(String name) {
        return new CreateJSParameterIntentionAction();
    }

    @Override
    public LocalQuickFix createJSFunctionIntentionAction(String name, boolean isMethod) {
        return new CreateJSFunctionIntentionAction(name, isMethod);
    }

    @Override
    public LocalQuickFix createJSFunctionFromArgumentIntentionAction(String name, JSExpression qualifier, boolean ecma) {
        return new CreateJSFunctionFromArgumentIntentionAction(name, qualifier, ecma);
    }

    @Override
    public LocalQuickFix createClassOrInterfaceFix(JSReferenceExpression expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)expression);
        if (holder == null) {
            return QuickFixes.EMPTY_FIX;
        }
        if (holder.isECMA4) {
            return new ActionScriptCreateClassOrInterfaceFix(expression, isInterface, constructorArguments, expectedType);
        }
        return new ES6CreateClassOrInterfaceFix(expression, isInterface, constructorArguments, expectedType);
    }

    @Override
    public IntentionAction addSuperInvocationFix(JSFunction constructor, @Nullable JSFunction superConstructor) {
        return new AddSuperInvocationFix(constructor, superConstructor);
    }

    @Override
    public IntentionAction addConstructorAndSuperInvocationFix(JSClass clazz, JSFunction superClassConstructor) {
        return new AddConstructorAndSuperInvocationFix(clazz, superClassConstructor);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction element, @Nullable JSArgumentList argumentList) {
        return new ChangeSignatureFix(element, argumentList);
    }

    @Override
    public LocalQuickFix createJSNamespaceIntentionAction(String name) {
        return new CreateJSNamespaceIntentionAction(name);
    }

    @Override
    public LocalQuickFix makeMethodStaticFix() {
        return new MakeMethodStaticFix();
    }

    @Override
    public FixAndIntentionAction assignParameterToFieldAction(FixAndIntentionAction action, String fieldName, String parameterName, String className) {
        return new AssignParameterToFieldAction(action, fieldName, parameterName, className);
    }

    @Override
    public LocalQuickFix downloadLibraryQuickFix() {
        return new DownloadLibraryQuickFix();
    }

    @Override
    public LocalQuickFix jsMoveToScopeStartIntentionAction(boolean statement) {
        return new JSMoveToScopeStartIntentionAction(statement);
    }

    @Override
    public FixAndIntentionAction removeElementLocalQuickFix(JSNamedElementKind kind, String name) {
        return new JSRemoveElementLocalQuickFix(kind, name);
    }

    @Override
    public void addFixesForFields(JSFunction node, PsiElement highlightedElement, String name, List<LocalQuickFix> fixes) {
        PsiElement element = JSResolveUtil.findParent((PsiElement)node);
        if (element instanceof JSClass) {
            FixAndIntentionAction intentionAction;
            String fieldName2;
            String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(node.isSetProperty() ? node.getName() : name, node.getProject());
            String string = fieldName2 = node.isSetProperty() ? null : JSRefactoringUtil.transformVarNameToAccessorName(name, node.getProject());
            if (StringUtil.equals((CharSequence)fieldName, (CharSequence)fieldName2)) {
                fieldName2 = null;
            }
            String className = ((JSClass)element).getName();
            boolean noField = ((JSClass)element).findFieldByName(fieldName) == null;
            String existingField = fieldName;
            if (noField && fieldName2 != null) {
                noField = ((JSClass)element).findFieldByName(fieldName2) == null;
                existingField = fieldName2;
            }
            CreateFieldFromParameterAction action = null;
            if (noField) {
                if (fieldName2 != null) {
                    action = new CreateFieldFromParameterAction(fieldName2);
                    action.registerElementRefForFix(highlightedElement, null);
                    intentionAction = JSFixFactoryImpl.assignParameterToFieldAction(name, fieldName2, className, action);
                    intentionAction.registerElementRefForFix(highlightedElement, null);
                    fixes.add(intentionAction);
                }
                action = new CreateFieldFromParameterAction(fieldName);
                action.registerElementRefForFix(highlightedElement, null);
            }
            intentionAction = JSFixFactoryImpl.assignParameterToFieldAction(name, noField ? fieldName : existingField, className, action);
            intentionAction.registerElementRefForFix(highlightedElement, null);
            fixes.add(intentionAction);
        }
    }

    private static FixAndIntentionAction assignParameterToFieldAction(String parameterName, String fieldName, String className, FixAndIntentionAction action) {
        return JSFixFactoryImpl.getInstance().assignParameterToFieldAction(action, fieldName, parameterName, className);
    }

    @Override
    public IntentionAction typeScriptImplementMethodsFix(JSClass aClass) {
        return new TypeScriptImplementMethodsFix(aClass);
    }

    @Override
    public LocalQuickFix createInsertTypeGuardFix(PsiElement element, String type) {
        return new TypeScriptInsertTypeGuardFix(element, type);
    }

    @Override
    public InspectionJSFix renameFix() {
        return new RenameFix();
    }

    @Override
    public LocalQuickFix typeScriptAddImportStatementFix(String name, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "typeScriptAddImportStatementFix"));
        }
        return new TypeScriptAddImportStatementFix(name, context);
    }

    @Override
    public FixAndIntentionAction replaceImplementsKeywordByExtendsFix(@NotNull JSReferenceList referenceList) {
        if (referenceList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceList", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "replaceImplementsKeywordByExtendsFix"));
        }
        return new JSReplaceImplementsExtendsKeyword(referenceList);
    }

    @Override
    @NotNull
    public List<LocalQuickFix> typeScriptConfigFixes(JSElement placeExpression, PsiElement resolveResult) {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new LocalQuickFix[]{new TypeScriptDisableConfigFix(), new TypeScriptAddFileToConfigFix(placeExpression, resolveResult)});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "typeScriptConfigFixes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public TypeScriptReferencePathValidator typeScriptReferencePathValidator() {
        TypeScriptReferencePathValidator typeScriptReferencePathValidator = TypeScriptReferencePathValidatorImpl.INSTANCE;
        if (typeScriptReferencePathValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "typeScriptReferencePathValidator"));
        }
        return typeScriptReferencePathValidator;
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement createChangeVisibilityFix(@NotNull JSAttributeListOwner method, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "createChangeVisibilityFix"));
        }
        return new JSSetElementVisibilityFix(method, visibility, namespace);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement insertModifier(@NotNull JSAttributeListOwner method, @NotNull JSAttributeList.ModifierType modifier) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "insertModifier"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "insertModifier"));
        }
        return new JSInsertModifierFix(method, modifier);
    }

    @Override
    public SuppressQuickFix suppressByCommentFix(HighlightDisplayKey key, Class<? extends JSSuppressionHolder> holderClass) {
        return new JSSuppressByCommentFix(key, holderClass);
    }

    @Override
    @Nullable
    public IntentionAction createChangeES6Import(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "createChangeES6Import"));
        }
        return TypeScriptChangeES6ImportIntention.create(declaration);
    }

    @Override
    public LocalQuickFix createConstructorFix(@NotNull JSCallExpression callExpression, @NotNull JSClass targetClass) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "createConstructorFix"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl", "createConstructorFix"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)callExpression);
        if (holder == null) {
            return QuickFixes.EMPTY_FIX;
        }
        return new ES6CreateConstructorFix(callExpression, targetClass);
    }
}

