/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveElementLocalQuickFix
extends FixAndIntentionAction
implements BatchQuickFix<CommonProblemDescriptor> {
    private static final Logger LOG = Logger.getInstance(JSRemoveElementLocalQuickFix.class);
    private final String myName;
    private final JSNamedElementKind myKind;

    public JSRemoveElementLocalQuickFix(JSNamedElementKind kind, String name) {
        this.myKind = kind;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String type = StringUtil.decapitalize((String)JSBundle.message((String)this.myKind.humanReadableKey(), (Object[])new Object[0]));
        String string = StringUtil.isEmptyOrSpaces((String)this.myName) ? JSBundle.message((String)"js.unused.symbol.remove.unnamed", (Object[])new Object[]{type}) : JSBundle.message((String)"js.unused.symbol.remove", (Object[])new Object[]{type, this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix", "getName"));
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        Runnable afterRefactoring;
        Document document;
        PsiElement element = JSRemoveElementLocalQuickFix.walkUpToDeleteTarget(psiElement);
        if (element == null) {
            return;
        }
        editor = editor == null ? PsiUtilBase.findEditor((PsiElement)psiElement) : editor;
        Document document2 = document = editor != null ? editor.getDocument() : null;
        if (document == null) {
            afterRefactoring = null;
        } else {
            MyRemovedReformatter reformatter = new MyRemovedReformatter(element, document);
            afterRefactoring = () -> DocumentUtil.writeInRunUndoTransparentAction(() -> {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                reformatter.reformat();
            });
        }
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{element}, null, (boolean)false, null, (Runnable)afterRefactoring);
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix", "applyFix"));
        }
        if (psiElementsToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix", "applyFix"));
        }
        List toDelete = Arrays.stream(descriptors).map(descriptor2 -> ((ProblemDescriptor)descriptor2).getPsiElement()).filter(Objects::nonNull).map(JSRemoveElementLocalQuickFix::walkUpToDeleteTarget).filter(Objects::nonNull).collect(Collectors.toList());
        if (toDelete.isEmpty()) {
            return;
        }
        psiElementsToIgnore.addAll(toDelete);
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray(toDelete), (boolean)false, (Runnable)refreshViews);
    }

    private static PsiElement walkUpToDeleteTarget(@NotNull PsiElement psiElement) {
        PsiElement element;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix", "walkUpToDeleteTarget"));
        }
        for (element = psiElement; element != null && !(element instanceof JSNamedElement) && !(element instanceof ES6ExportDefaultAssignment); element = element.getParent()) {
        }
        if (element == null) {
            LOG.info("Was not able to remove element: " + psiElement.getText());
        }
        if (element != null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            element = element.getParent();
        }
        return element;
    }

    private static class MyLeftRightContext {
        @Nullable
        private PsiElement myLeft;
        @Nullable
        private PsiElement myRight;
        @Nullable
        private PsiElement myParent;
        private final boolean myInline;

        public MyLeftRightContext(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyLeftRightContext", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyLeftRightContext", "<init>"));
            }
            this.myLeft = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(element);
            this.myRight = JSPsiImplUtils.getNextSiblingIgnoreWhitespace(element);
            this.myParent = element.getParent();
            this.myInline = this.myLeft != null && this.myRight != null && document.getLineNumber(this.myLeft.getTextRange().getEndOffset()) == document.getLineNumber(this.myRight.getTextRange().getStartOffset());
        }

        boolean isInline() {
            return this.myInline;
        }

        @Nullable
        PsiElement getParent() {
            return this.myParent;
        }

        @Nullable
        TextRange getTextRangeIfValid() {
            if (this.myParent == null || !this.myParent.isValid()) {
                return null;
            }
            boolean prevValid = this.myLeft != null && this.myLeft.isValid();
            boolean nextValid = this.myRight != null && this.myRight.isValid();
            int startOffset = prevValid ? this.myLeft.getTextRange().getEndOffset() : this.myParent.getTextRange().getStartOffset();
            int endOffset = nextValid ? this.myRight.getTextRange().getStartOffset() : this.myParent.getTextRange().getEndOffset();
            return new TextRange(startOffset, endOffset);
        }

        boolean isWholeFile() {
            return this.myParent instanceof PsiFile && this.myLeft == null && this.myRight == null;
        }
    }

    private static class MyRemovedReformatter {
        private final List<MyLeftRightContext> myContexts;
        private final PsiFile myContainingFile;
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final Document myDocument;

        public MyRemovedReformatter(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter", "<init>"));
            }
            this.myElement = element;
            this.myDocument = document;
            this.myContexts = MyRemovedReformatter.createContextList(element, document);
            this.myContainingFile = element.getContainingFile();
        }

        public void reformat() {
            if (this.myElement.isValid()) {
                return;
            }
            MyLeftRightContext context = this.myContexts.stream().filter(c -> c.getTextRangeIfValid() != null).findFirst().orElse(null);
            if (context == null) {
                return;
            }
            TextRange range = context.getTextRangeIfValid();
            assert (range != null);
            if (context.isInline()) {
                FormatFixer.create(this.myContainingFile, range, FormatFixer.Mode.Reformat).fixFormat();
            } else {
                Project project = this.myContainingFile.getProject();
                if (context.isWholeFile() || range.getStartOffset() == 0) {
                    if (range.getLength() > 0) {
                        this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
                        PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    }
                } else {
                    this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"\n");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(this.myContainingFile, range);
                }
            }
        }

        @NotNull
        private static List<MyLeftRightContext> createContextList(@NotNull PsiElement element, @NotNull Document document) {
            MyLeftRightContext context;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter", "createContextList"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter", "createContextList"));
            }
            SmartList result = new SmartList();
            PsiElement current = element;
            while (current != null && !(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent) && (context = new MyLeftRightContext(current, document)).getParent() != null) {
                result.add(context);
                current = context.getParent();
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyRemovedReformatter", "createContextList"));
            }
            return smartList;
        }
    }
}

