/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariableInitializationExtractor {
    public static final TokenSet EXPORT_KEYWORD = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});
    private final JSLanguageDialect myDialect;
    private final JSVarStatement myVarStatement;
    private final Set<JSVariable> myVariablesToExtract;
    private final Set<JSVariable> myVariablesToDelete;
    private final Set<JSVariable> myToBeConst;
    @Nullable
    private JSVarStatement.VarKeyword myNewKeyword;
    private boolean myNotApplicable;

    public JSVariableInitializationExtractor(@NotNull List<JSVariable> variables, @NotNull JSVarStatement statement) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "<init>"));
        }
        this(statement, variables.toArray(JSVariable.EMPTY_ARRAY));
    }

    public JSVariableInitializationExtractor(JSVariable ... variables) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "<init>"));
        }
        this((JSVarStatement)null, variables);
    }

    public JSVariableInitializationExtractor(@Nullable JSVarStatement statement, JSVariable ... variables) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "<init>"));
        }
        this.myToBeConst = new HashSet<JSVariable>();
        this.myVariablesToExtract = new HashSet<JSVariable>(Arrays.asList(variables));
        for (JSVariable variable : variables) {
            if (variable.getParent() instanceof JSDestructuringArray) {
                this.myNotApplicable = true;
                this.myVariablesToExtract.clear();
                this.myVarStatement = null;
                this.myVariablesToDelete = null;
                this.myDialect = null;
                return;
            }
            assert (variable.getParent() instanceof JSVarStatement);
            assert (statement == null || statement == variable.getParent());
            statement = (JSVarStatement)variable.getParent();
        }
        this.myVarStatement = statement;
        this.myVariablesToDelete = new HashSet<JSVariable>();
        this.myDialect = DialectDetector.languageDialectOfElement((PsiElement)this.myVarStatement);
    }

    public JSVariableInitializationExtractor withNewKeyword(@NotNull JSVarStatement.VarKeyword keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "withNewKeyword"));
        }
        this.myNewKeyword = keyword;
        return this;
    }

    public void toBeConst(@NotNull Collection<JSVariable> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "toBeConst"));
        }
        this.myToBeConst.addAll(collection);
        this.myNewKeyword = JSVarStatement.VarKeyword.LET;
    }

    public void deleteExtracted(@NotNull Collection<JSVariable> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "deleteExtracted"));
        }
        this.myVariablesToDelete.addAll(collection);
    }

    public List<PsiElement> transform() {
        JSVarStatement transformationAnchor;
        if (this.myNotApplicable) {
            return Collections.emptyList();
        }
        FragmentsSplitter fragmentsSplitter = new FragmentsSplitter(variable -> {
            boolean flag = this.myVariablesToExtract.contains(variable);
            if (flag && (variable.getInitializer() == null || this.myVariablesToDelete.contains(variable))) {
                return null;
            }
            return flag;
        });
        fragmentsSplitter.split(this.myVarStatement.getVariables());
        if (this.insideFor()) {
            if (this.myVarStatement.getVariables().length > 1) {
                transformationAnchor = this.myVarStatement.getParent();
            } else {
                transformationAnchor = this.myVarStatement;
                if (this.myVarStatement.getVariables().length == 1 && this.insideFor()) {
                    JSVariable variable2 = this.myVarStatement.getVariables()[0];
                    if (!((Boolean)fragmentsSplitter.extractFlagList.get(0)).booleanValue()) {
                        PsiElement keyword = this.myVarStatement.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS).getPsi();
                        if (keyword == null) {
                            return Collections.emptyList();
                        }
                        PsiElement replacementKeyword = this.createKeyword();
                        if (replacementKeyword == null) {
                            return Collections.emptyList();
                        }
                        return Collections.singletonList(keyword.replace(replacementKeyword));
                    }
                    if (variable2.getInitializer() != null) {
                        this.myVarStatement.replace((PsiElement)JSVariableInitializationExtractor.createInitializer(variable2).getExpression());
                        return Collections.singletonList(this.myVarStatement);
                    }
                    this.deleteOldVarStatement(null);
                    return Collections.emptyList();
                }
            }
        } else {
            transformationAnchor = this.myVarStatement;
        }
        ArrayList<PsiElement> addedElements = new ArrayList<PsiElement>();
        if (!fragmentsSplitter.isEmpty()) {
            fragmentsSplitter.iterate((PairConsumer<Boolean, List<JSVariable>>)((PairConsumer)(arg_0, arg_1) -> this.lambda$transform$1(addedElements, (PsiElement)transformationAnchor, arg_0, arg_1)));
            PsiElement extraWs = this.myVarStatement.getPrevSibling();
            if (extraWs instanceof PsiWhiteSpace && !addedElements.contains(extraWs)) {
                extraWs.delete();
            }
        }
        this.deleteOldVarStatement(addedElements);
        return addedElements;
    }

    private void deleteOldVarStatement(@Nullable List<PsiElement> addedElements) {
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)this.myVarStatement);
        if (comment != null && addedElements != null && !addedElements.isEmpty()) {
            this.moveComment(comment, addedElements);
        }
        this.myVarStatement.delete();
    }

    private void moveComment(@NotNull PsiComment comment, @Nullable List<PsiElement> addedElements) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "moveComment"));
        }
        PsiElement anchor = null;
        if (addedElements == null || addedElements.isEmpty()) {
            if (this.myVarStatement.getPrevSibling() != null) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)this.myVarStatement.getPrevSibling(), JSSourceElement.class);
            }
        } else {
            for (PsiElement element : addedElements) {
                if (!(element instanceof JSVarStatement)) continue;
                anchor = element;
                break;
            }
            if (anchor == null) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)addedElements.get(0), JSSourceElement.class);
            }
        }
        if (anchor != null) {
            JSDocumentationUtils.moveJSDoc(comment, anchor);
        }
    }

    private PsiElement createKeyword() {
        JSVarStatement.VarKeyword keyword = this.determineKeyword();
        if (keyword == null) {
            return null;
        }
        PsiElement newSt = JSChangeUtil.createStatementFromText(this.myVarStatement.getProject(), keyword.getText() + " a;").getPsi();
        return newSt.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS).getPsi();
    }

    private boolean insideFor() {
        return this.myVarStatement.getParent() instanceof JSForStatement || this.myVarStatement.getParent() instanceof JSForInStatement;
    }

    private void addDeclarations(PsiElement transformationAnchor, List<PsiElement> addedElements, List<JSVariable> fragment) {
        if (!this.myToBeConst.isEmpty()) {
            FragmentsSplitter fragmentsSplitter = new FragmentsSplitter(this.myToBeConst::contains);
            fragmentsSplitter.split(fragment.toArray(new JSVariable[0]));
            PsiElement finalTransformationAnchor = transformationAnchor;
            fragmentsSplitter.iterate((PairConsumer<Boolean, List<JSVariable>>)((PairConsumer)(flag, innerFragment) -> {
                JSSourceElement statement = this.createLetStatement((List<JSVariable>)innerFragment, flag != false ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET);
                addedElements.add(finalTransformationAnchor.getParent().addBefore((PsiElement)statement, finalTransformationAnchor));
            }));
        } else {
            addedElements.add(JSChangeUtil.doDoAddBefore(transformationAnchor.getParent(), (PsiElement)this.createLetStatement(fragment), transformationAnchor));
        }
    }

    private static JSExpressionStatement createInitializer(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "createInitializer"));
        }
        JSExpressionStatement st = JSChangeUtil.createStatementPsiFromTextWithContext(variable.getName() + "= 1" + JSCodeStyleSettings.getSemicolon(variable.getContainingFile()), (PsiElement)variable, JSExpressionStatement.class);
        assert (st != null);
        JSExpression expression = st.getExpression();
        assert (expression instanceof JSAssignmentExpression);
        ((JSAssignmentExpression)expression).getDefinitionExpression().getInitializer().replace(variable.getInitializer().copy());
        return st;
    }

    private JSSourceElement createLetStatement(@NotNull List<JSVariable> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "createLetStatement"));
        }
        return this.createLetStatement(list, this.determineKeyword());
    }

    private JSSourceElement createLetStatement(@NotNull List<JSVariable> list, @NotNull JSVarStatement.VarKeyword keyword) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "createLetStatement"));
        }
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "createLetStatement"));
        }
        Ref attributes = new Ref((Object)"");
        assert (!list.isEmpty());
        String middleText = list.stream().map(variable -> {
            PsiElement forwardComma;
            String attributeList = JSVariableInitializationExtractor.getAttributeList(variable);
            if (attributeList != null) {
                attributes.set((Object)(attributeList + " "));
            }
            SmartList parts = new SmartList();
            PsiElement backwardCommaOrVar = PsiTreeUtil.skipSiblingsBackward((PsiElement)variable, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            if (backwardCommaOrVar != null) {
                JSVariableInitializationExtractor.fetchInBetween(backwardCommaOrVar.getNextSibling(), (PsiElement)variable, (List<PsiElement>)parts);
            }
            if ((forwardComma = PsiTreeUtil.skipSiblingsForward((PsiElement)variable, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null) {
                JSVariableInitializationExtractor.fetchInBetween((PsiElement)variable, forwardComma, (List<PsiElement>)parts);
            } else {
                parts.add(variable);
            }
            return parts.stream().map(PsiElement::getText).collect(Collectors.joining(""));
        }).collect(Collectors.joining(","));
        middleText = StringUtil.trimLeading((String)middleText);
        String text = attributes + keyword.getText() + " " + middleText + JSCodeStyleSettings.getSemicolon(this.myVarStatement.getContainingFile());
        return JSChangeUtil.createVarStatement(text, (PsiElement)this.myVarStatement);
    }

    private static void fetchInBetween(@Nullable PsiElement from, @NotNull PsiElement toExcluding, @NotNull List<PsiElement> list) {
        if (toExcluding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toExcluding", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "fetchInBetween"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "fetchInBetween"));
        }
        for (PsiElement current = from; current != null && !current.equals(toExcluding); current = current.getNextSibling()) {
            list.add(current);
        }
    }

    @Nullable
    private static String getAttributeList(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor", "getAttributeList"));
        }
        JSAttributeList attributeList = variable.getAttributeList();
        return attributeList != null && !StringUtil.isEmptyOrSpaces((String)attributeList.getText()) ? attributeList.getText() : null;
    }

    private JSVarStatement.VarKeyword determineKeyword() {
        if (this.myNewKeyword != null) {
            return this.myNewKeyword;
        }
        JSVarStatement.VarKeyword keyword = this.myVarStatement.getVarKeyword();
        return keyword != null ? keyword : JSVarStatement.VarKeyword.LET;
    }

    private /* synthetic */ void lambda$transform$1(List addedElements, PsiElement transformationAnchor, Boolean flag, List fragment) {
        if (flag.booleanValue()) {
            for (JSVariable variable : fragment) {
                if (variable.getInitializer() == null) continue;
                addedElements.add(transformationAnchor.getParent().addBefore((PsiElement)JSVariableInitializationExtractor.createInitializer(variable), transformationAnchor));
            }
        } else {
            this.addDeclarations(transformationAnchor, addedElements, fragment);
        }
    }

    private static class FragmentsSplitter {
        @NotNull
        private final Convertor<JSVariable, Boolean> convertor;
        private final List<Boolean> extractFlagList;
        private final List<List<JSVariable>> fragments;

        private FragmentsSplitter(@NotNull Convertor<JSVariable, Boolean> convertor) {
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor$FragmentsSplitter", "<init>"));
            }
            this.extractFlagList = new ArrayList<Boolean>();
            this.fragments = new ArrayList<List<JSVariable>>();
            this.convertor = convertor;
        }

        public void split(JSVariable[] variables) {
            ArrayList<JSVariable> current = new ArrayList<JSVariable>();
            boolean currentFlag = false;
            for (JSVariable variable : variables) {
                Boolean futureFlag = (Boolean)this.convertor.convert((Object)variable);
                if (futureFlag == null) continue;
                if (futureFlag != currentFlag) {
                    if (!current.isEmpty()) {
                        this.extractFlagList.add(currentFlag);
                        this.fragments.add(current);
                        current = new ArrayList();
                    }
                    currentFlag = futureFlag;
                }
                current.add(variable);
            }
            if (!current.isEmpty()) {
                this.extractFlagList.add(currentFlag);
                this.fragments.add(current);
            }
            assert (this.fragments.size() == this.extractFlagList.size());
        }

        public void iterate(@NotNull PairConsumer<Boolean, List<JSVariable>> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor$FragmentsSplitter", "iterate"));
            }
            for (int i = 0; i < this.fragments.size(); ++i) {
                List<JSVariable> fragment = this.fragments.get(i);
                boolean flag = this.extractFlagList.get(i);
                consumer.consume((Object)flag, fragment);
            }
        }

        public boolean isEmpty() {
            return this.fragments.isEmpty();
        }
    }
}

