/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintSuppressionUtil;
import com.intellij.lang.javascript.linter.eslint.service.ESLintLanguageService;
import com.intellij.lang.javascript.linter.jscs.EsLintFixAction;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Convertor;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintExternalAnnotator
extends JSLinterExternalAnnotator<EslintState> {
    private static final EslintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new EslintExternalAnnotator(false);

    @NotNull
    public static EslintExternalAnnotator getInstanceForBatchInspection() {
        EslintExternalAnnotator eslintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (eslintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return eslintExternalAnnotator;
    }

    public EslintExternalAnnotator() {
        this(true);
    }

    public EslintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected UntypedJSLinterConfigurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSettingsConfigurable"));
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSettingsConfigurable"));
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected Class<EslintInspection> getInspectionClass() {
        return EslintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "acceptPsiFile"));
        }
        return EslintExternalAnnotator.acceptPsiFileForEslintAnnotation(file);
    }

    public static boolean acceptPsiFileForEslintAnnotation(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "acceptPsiFileForEslintAnnotation"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file) || JSLinterUtil.isPureHtmlFile(file) || JSLinterUtil.isVueFile(file) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    @Override
    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return JavaScriptLanguageIcons.FileTypes.Eslint;
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<EslintState> annotate(@NotNull JSLinterInput<EslintState> input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "annotate"));
        }
        ESLintLanguageService service = ESLintLanguageService.getInstance(input.getProject());
        return new EsLintExternalRunner(this.isOnTheFly(), false, service).execute(input);
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<EslintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        EslintConfigurable configurable = new EslintConfigurable(file.getProject(), true);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditSettingsAction(new JSLinterEditSettingsAction(configurable, JavaScriptLanguageIcons.FileTypes.Eslint)).setOtherFixes(Collections.singletonList(new EsLintFixAction().asIntentionAction())).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)o -> EslintSuppressionUtil.getSuppressionsForError(o, this.isOnTheFly())));
        new JSLinterAnnotationsBuilder<EslintState>(file, annotationResult, holder, EslintInspection.getHighlightDisplayKey(), configurable, "ESLint: ", this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }
}

