/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRulesImporter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class EslintRuleMapper {
    private static final Set<String> TURNED_ON = ContainerUtil.set((Object[])new String[]{"warn", "error"});
    @NonNls
    private static final String ALWAYS = "always";
    @NonNls
    private static final String NEVER = "never";
    protected static final String BEFORE = "before";
    protected static final String AFTER = "after";
    private final String myName;

    protected EslintRuleMapper(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    protected abstract EslintRulesImporter.SettingsConvertor create(@Nullable List<JsonValue> var1);

    public EslintRulesImporter.SettingsConvertor parseSettings(@NotNull JsonValue element) {
        JsonArray asArray;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseSettings"));
        }
        JsonLiteral literal = (JsonLiteral)ObjectUtils.tryCast((Object)element, JsonLiteral.class);
        List optionsList = null;
        if (literal == null && (asArray = (JsonArray)ObjectUtils.tryCast((Object)element, JsonArray.class)) != null && !asArray.getValueList().isEmpty()) {
            List list = asArray.getValueList();
            literal = (JsonLiteral)ObjectUtils.tryCast(list.get(0), JsonLiteral.class);
            optionsList = list.subList(1, list.size());
        }
        if (literal == null) {
            return EslintRulesImporter.MISCONFIGURATION;
        }
        RuleState severity = EslintRuleMapper.parseRuleSeverity(literal);
        if (!RuleState.ok.equals((Object)severity)) {
            return new EslintRulesImporter.SettingsConvertor(severity);
        }
        return this.create(optionsList);
    }

    @Nullable
    protected Boolean getAlwaysNeverOption(@Nullable List<JsonValue> values, boolean defaultValue) {
        if (values != null && !values.isEmpty()) {
            return this.readValueAsStringWithTwoVariants(values.get(0), ALWAYS, NEVER);
        }
        return defaultValue;
    }

    protected Boolean readValueAsStringWithTwoVariants(@Nullable JsonValue value, @NotNull String trueStr, @NotNull String falseStr) {
        if (trueStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueStr", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "readValueAsStringWithTwoVariants"));
        }
        if (falseStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "falseStr", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "readValueAsStringWithTwoVariants"));
        }
        JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)value, JsonStringLiteral.class);
        if (literal != null) {
            String text = StringUtil.unquoteString((String)literal.getValue());
            if (trueStr.equals(text)) {
                return true;
            }
            if (falseStr.equals(text)) {
                return false;
            }
        }
        return null;
    }

    @NotNull
    private static RuleState parseRuleSeverity(@NotNull JsonLiteral asLiteral) {
        if (asLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asLiteral", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
        }
        if (asLiteral.isQuotedString()) {
            String text = StringUtil.unquoteString((String)asLiteral.getText());
            if ("off".equals(text)) {
                RuleState ruleState = RuleState.off;
                if (ruleState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
                }
                return ruleState;
            }
            if (TURNED_ON.contains(text)) {
                RuleState ruleState = RuleState.ok;
                if (ruleState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
                }
                return ruleState;
            }
            RuleState ruleState = RuleState.misconfiguration;
            if (ruleState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
            }
            return ruleState;
        }
        Integer value = EslintRuleMapper.getInteger((JsonValue)asLiteral);
        if (value == null) {
            RuleState ruleState = RuleState.misconfiguration;
            if (ruleState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
            }
            return ruleState;
        }
        if (value == 0) {
            RuleState ruleState = RuleState.off;
            if (ruleState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
            }
            return ruleState;
        }
        if (value == 1 || value == 2) {
            RuleState ruleState = RuleState.ok;
            if (ruleState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
            }
            return ruleState;
        }
        RuleState ruleState = RuleState.misconfiguration;
        if (ruleState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "parseRuleSeverity"));
        }
        return ruleState;
    }

    protected static Integer getInteger(@NotNull JsonValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "getInteger"));
        }
        JsonNumberLiteral number = (JsonNumberLiteral)ObjectUtils.tryCast((Object)value, JsonNumberLiteral.class);
        if (number != null) {
            try {
                return Integer.parseInt(number.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    protected Boolean getArrayLineBreakRulesOption(@Nullable List<JsonValue> values) {
        Boolean isOn = this.getAlwaysNeverOption(values, true);
        if (isOn == null && values != null && values.size() > 0) {
            Integer num;
            JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
            if (object == null) {
                return null;
            }
            JsonProperty minItems = object.findProperty("minItems");
            if (minItems != null && minItems.getValue() != null && (num = EslintRuleMapper.getInteger(minItems.getValue())) != null && num == 0) {
                return true;
            }
        }
        return isOn;
    }

    @Nullable
    protected static Boolean getBooleanOptionValue(@NotNull JsonObject object, @NotNull String name, boolean defaultValue) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "getBooleanOptionValue"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "getBooleanOptionValue"));
        }
        JsonProperty property = object.findProperty(name);
        if (property == null) {
            return defaultValue;
        }
        JsonBooleanLiteral booleanValue = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonBooleanLiteral.class);
        if (booleanValue == null) {
            return null;
        }
        return booleanValue.getValue();
    }

    @Nullable
    protected static BeforeAfter<Boolean> getBeforeAfter(@Nullable List<JsonValue> values, boolean beforeDefault, boolean afterDefault) {
        if (values != null && !values.isEmpty()) {
            JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
            if (config2 == null) {
                return null;
            }
            return EslintRuleMapper.getBeforeAfter(config2, beforeDefault, afterDefault);
        }
        return new BeforeAfter((Object)beforeDefault, (Object)afterDefault);
    }

    @Nullable
    protected static BeforeAfter<Boolean> getBeforeAfter(@NotNull JsonObject config2, boolean beforeDefault, boolean afterDefault) {
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper", "getBeforeAfter"));
        }
        Boolean isBefore = EslintRuleMapper.getBooleanOptionValue(config2, BEFORE, beforeDefault);
        Boolean isAfter = EslintRuleMapper.getBooleanOptionValue(config2, AFTER, afterDefault);
        if (isBefore == null || isAfter == null) {
            return null;
        }
        return new BeforeAfter((Object)isBefore, (Object)isAfter);
    }

    public static enum RuleState {
        off,
        misconfiguration,
        skipped,
        sameSettings,
        ok;

    }
}

