/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.formatter.StandardJSCodeStyle;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSCodeStyleNotifierProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final EditorNotifications myEditorNotifications;
    private final StandardJSConfiguration myStandardJSConfiguration;
    private final EslintConfiguration myEslintConfiguration;
    private final boolean isUnitTest;
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"standardjs.codestyle.notification.panel");
    private static final String CLOSED = "standardjs.codestyle.accepted";

    public StandardJSCodeStyleNotifierProvider(PropertiesComponent propertiesComponent, EditorNotifications editorNotifications, StandardJSConfiguration standardJSConfiguration, EslintConfiguration eslintConfiguration, Application application) {
        this.isUnitTest = application.isUnitTestMode();
        this.myPropertiesComponent = propertiesComponent;
        this.myEditorNotifications = editorNotifications;
        this.myStandardJSConfiguration = standardJSConfiguration;
        this.myEslintConfiguration = eslintConfiguration;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider", "createNotificationPanel"));
        }
        if (this.isUnitTest || !(fileEditor instanceof TextEditor)) {
            return null;
        }
        Project project = ((TextEditor)fileEditor).getEditor().getProject();
        if (project == null) {
            return null;
        }
        boolean isJS = JSUtils.isJavaScriptFile(file);
        if (this.myPropertiesComponent.getBoolean(CLOSED) || !isJS || StandardJSCodeStyle.isInstalled(project)) {
            return null;
        }
        if (this.myStandardJSConfiguration.isEnabled() && StandardJSCodeStyleNotifierProvider.hasStandardJSPackage(project) || this.myEslintConfiguration.isEnabled() && StandardJSCodeStyleNotifierProvider.hasEslintConfigFileWithPlugin(project)) {
            EditorNotificationPanel panel = new EditorNotificationPanel(LightColors.YELLOW).text(JSBundle.message((String)"standardjs.editor.notification.can.be.enabled.text", (Object[])new Object[0]));
            panel.createActionLabel(JSBundle.message((String)"standardjs.editor.notification.action", (Object[])new Object[0]), () -> {
                StandardJSCodeStyle.install(project);
                this.myPropertiesComponent.setValue(CLOSED, true);
                this.myEditorNotifications.updateAllNotifications();
            });
            panel.createActionLabel(JSBundle.message((String)"standardjs.editor.notification.do.not.show.text", (Object[])new Object[0]), () -> {
                this.myPropertiesComponent.setValue(CLOSED, true);
                this.myEditorNotifications.updateAllNotifications();
            });
            return panel;
        }
        return null;
    }

    private static boolean hasStandardJSPackage(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider", "hasStandardJSPackage"));
        }
        PackageJsonData data = PackageJsonUtil.getTopLevelPackageJsonData(project);
        return data != null && data.getAllDependencies().contains("standard");
    }

    private static boolean hasEslintConfigFileWithPlugin(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider", "hasEslintConfigFileWithPlugin"));
        }
        List<VirtualFile> configs = EslintUtil.findAllConfigsInScope(project, GlobalSearchScope.projectScope((Project)project));
        return ContainerUtil.or(configs, file -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider", "lambda$hasEslintConfigFileWithPlugin$2"));
            }
            EslintUtil.EslintConfigData configData = EslintUtil.parseConfigFile(project, file);
            return configData != null && ContainerUtil.intersects(configData.getExtends(), StandardJSUtil.ESLINT_CONFIGURATION_NAMES);
        });
    }
}

