/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.lang.javascript.linter.JSLinterConfigChangeTracker;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class JscsConfigFileChangeTracker
extends JSLinterConfigChangeTracker {
    public JscsConfigFileChangeTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileChangeTracker", "<init>"));
        }
        super(project, (FileType)JscsConfigFileType.INSTANCE);
    }

    public static JscsConfigFileChangeTracker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileChangeTracker", "getInstance"));
        }
        return (JscsConfigFileChangeTracker)ServiceManager.getService((Project)project, JscsConfigFileChangeTracker.class);
    }

    @Override
    protected boolean isAnalyzerRestartNeeded(@NotNull Project project, @NotNull VirtualFile changedFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        if (changedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFile", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        JscsConfiguration configuration = JscsConfiguration.getInstance(project);
        JscsState state = (JscsState)configuration.getExtendedState().getState();
        if (state.isCustomConfigFileUsed()) {
            VirtualFile configVirtualFile = JSLinterConfigFileUtil.findLocalFileByPath(state.getCustomConfigFilePath());
            return changedFile.equals(configVirtualFile);
        }
        return true;
    }
}

