/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleNameInfo {
    @Nullable
    private final VirtualFile myModule;
    @NotNull
    private final VirtualFile myResolvedFile;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myQuote;

    public JSModuleNameInfo(@Nullable String path, @NotNull VirtualFile module, @NotNull PsiElement context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        this(path, module, module, context, true);
    }

    public JSModuleNameInfo(@Nullable String path, @NotNull VirtualFile module, @NotNull PsiElement context, boolean removeExtension) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        this(path, module, module, context, removeExtension);
    }

    public JSModuleNameInfo(@Nullable String path, @Nullable VirtualFile module, @NotNull VirtualFile resolvedFile, @NotNull PsiElement context) {
        if (resolvedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedFile", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        this(path, module, resolvedFile, context, true);
    }

    public JSModuleNameInfo(@Nullable String path, @Nullable VirtualFile module, @NotNull VirtualFile resolvedFile, @NotNull PsiElement context, boolean removeExtension) {
        if (resolvedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedFile", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "<init>"));
        }
        this.myQuote = JSCodeStyleSettings.getQuote(context);
        String extension = removeExtension ? JSFileReference.findImplicitExtension(path) : null;
        String externalModuleName = StringUtil.notNullize((String)path);
        if (extension != null) {
            externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)extension);
        }
        this.myModuleName = externalModuleName;
        this.myModule = module;
        this.myResolvedFile = resolvedFile;
    }

    public boolean isValid() {
        return this.getModule() != null && !StringUtil.isEmpty((String)this.myModuleName);
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myQuote + this.getModuleName() + this.myQuote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "getPath"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getModule() {
        return this.myModule;
    }

    @NotNull
    public VirtualFile getPathFile() {
        VirtualFile virtualFile = this.myResolvedFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSModuleNameInfo", "getPathFile"));
        }
        return virtualFile;
    }

    public String toString() {
        return this.getPath();
    }
}

