/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDocumentDependencies {
    private static final Key<CachedValue<PackageJsonDependencies>> PACKAGE_JSON_DEPENDENCIES = Key.create((String)"Node.js.package.json.dependencies");

    public static PackageJsonDocumentDependencies getInstance() {
        return (PackageJsonDocumentDependencies)ServiceManager.getService(PackageJsonDocumentDependencies.class);
    }

    @Nullable
    public PackageJsonDependencies getForFile(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getForFile"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getForFile"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(packageJson);
        if (psiFile == null) {
            return null;
        }
        return (PackageJsonDependencies)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)psiFile, PACKAGE_JSON_DEPENDENCIES, () -> {
            PackageJsonDependencies deps = PackageJsonDocumentDependencies.createDependencies(psiFile);
            return new CachedValueProvider.Result((Object)deps, new Object[]{psiFile});
        }, false);
    }

    @Nullable
    private static PackageJsonDependencies createDependencies(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "createDependencies"));
        }
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
        if (file == null || !file.isValid()) {
            return null;
        }
        JsonObject topObject = (JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), JsonObject.class);
        if (topObject == null) {
            return null;
        }
        return new PackageJsonDependencies(PackageJsonDocumentDependencies.getDependencies(topObject, PackageJsonField.dependencies.getName()), PackageJsonDocumentDependencies.getDependencies(topObject, PackageJsonField.devDependencies.getName()), PackageJsonDocumentDependencies.getDependencies(topObject, PackageJsonField.optionalDependencies.getName()));
    }

    @NotNull
    private static Map<String, String> getDependencies(@NotNull JsonObject topObject, @NotNull String propertyName) {
        if (topObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topObject", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getDependencies"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getDependencies"));
        }
        JsonProperty deps = topObject.findProperty(propertyName);
        Map<String, String> map = deps != null ? PackageJsonDocumentDependencies.getDependencies(deps) : Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getDependencies"));
        }
        return map;
    }

    @NotNull
    private static Map<String, String> getDependencies(@NotNull JsonProperty deps) {
        if (deps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deps", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getDependencies"));
        }
        JsonValue value = deps.getValue();
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
        if (object == null) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getDependencies"));
            }
            return map;
        }
        List list = object.getPropertyList();
        HashMap<String, String> dependencies = new HashMap<String, String>(list.size());
        for (JsonProperty property : list) {
            JsonLiteral literal = (JsonLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonLiteral.class);
            if (literal == null || !literal.isQuotedString()) continue;
            dependencies.put(property.getName().trim(), StringUtil.unquoteString((String)literal.getText()));
        }
        HashMap<String, String> hashMap = dependencies;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/PackageJsonDocumentDependencies", "getDependencies"));
        }
        return hashMap;
    }
}

