/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSContextExpectedTypeEvaluator
extends JSElementVisitor {
    protected final JSExpression myParent;
    protected final PsiElement myGrandParent;
    protected JSType myResult;

    public JSContextExpectedTypeEvaluator(JSExpression parent) {
        this.myParent = parent;
        this.myGrandParent = this.myParent.getParent();
    }

    @Nullable
    public JSType findExpectedType() {
        this.myGrandParent.accept((PsiElementVisitor)this);
        return this.myResult;
    }

    protected abstract JSContextExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression var1);

    public void visitJSVariable(JSVariable node) {
        this.myResult = node.getType();
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand != null) {
            PsiElement resolve;
            JSExpression expression;
            if ((lOperand = (JSExpression)PsiUtilCore.getOriginalElement((PsiElement)lOperand, lOperand.getClass())) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) != null && JSResolveUtil.isSameReference((JSReferenceExpression)expression, resolve)) {
                return;
            }
            this.myResult = JSResolveUtil.getQualifiedExpressionJSType(lOperand, this.myGrandParent.getContainingFile());
        }
    }

    public void visitJSArgumentList(@NotNull JSArgumentList node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/JSContextExpectedTypeEvaluator", "visitJSArgumentList"));
        }
        JSExpression mainOccurrence = this.myParent;
        int _paramIndex = 0;
        for (JSExpression expr : node.getArguments()) {
            if (expr == mainOccurrence) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = node.getFirstChild();
        if (firstChild == null) {
            return;
        }
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        JSExpression methodExpr = originalElement.getMethodExpression();
        boolean isExplicitly = this.hasExplicitlyQualifierType(methodExpr);
        if (!(methodExpr instanceof JSReferenceExpression)) {
            return;
        }
        ResolveResult[] results = ((JSReferenceExpression)methodExpr).multiResolve(false);
        JSFunctionItem matchedFunction = null;
        ArrayList possibleResults = ContainerUtil.newArrayList();
        for (ResolveResult r : results) {
            TypeScriptJSFunctionTypeImpl functionType;
            JSType type;
            PsiElement element = r.getElement();
            if (element == null || !element.isValid()) continue;
            if (element instanceof JSParameter) {
                JSType index;
                JSType type2;
                JSType definedParameterType = ((JSParameter)element).getType();
                JSEvaluateContext context = new JSEvaluateContext(null);
                JSType jSType = type2 = definedParameterType != null ? definedParameterType : JSContextTypeEvaluator.getParameterType((JSParameter)element, context);
                if (!context.isJSElementsToApplyEmpty() || !(type2 instanceof JSFunctionTypeImpl) || (index = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type2, paramIndex)) == null) continue;
                possibleResults.add(index);
                continue;
            }
            JSFunctionWithSubstitutor functionWithSubstitutor = this.calcFunctionForArgumentList(originalElement, element);
            if (functionWithSubstitutor == null) continue;
            matchedFunction = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor typeSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            if (typeSubstitutor == null || typeSubstitutor.isEmpty()) {
                JSContextExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, (List<JSType>)possibleResults);
                continue;
            }
            if (!(matchedFunction instanceof JSFunction) || !((type = JSTypeUtils.applyGenericArguments(functionType = TypeScriptTypeParser.buildFunctionTypeWithoutTypeArguments((JSFunction)matchedFunction), (Map<String, JSType>)typeSubstitutor)) instanceof JSFunctionTypeImpl)) continue;
            JSContextExpectedTypeEvaluator.addPossibleTypes(paramIndex, (JSFunctionTypeImpl)type, (List<JSType>)possibleResults);
        }
        if (!possibleResults.isEmpty()) {
            this.myResult = possibleResults.size() == 1 ? (JSType)ContainerUtil.getFirstItem((List)possibleResults) : JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(this.myGrandParent, false), possibleResults));
            if (!isExplicitly) {
                this.myResult = JSTypeUtils.copyWithExplicitlyDeclared(this.myResult, false);
            }
        }
        this.postProcessType(matchedFunction, (JSReferenceExpression)methodExpr);
    }

    private static void addPossibleTypes(int paramIndex, JSFunctionItem matchedFunction, List<JSType> possibleResults) {
        if (matchedFunction != null) {
            JSParameterItem[] params = matchedFunction.getParameters();
            if (params.length == 0) {
                return;
            }
            List<JSType> parameterTypes = Arrays.stream(params).map(JSParameterItem::getType).collect(Collectors.toList());
            JSContextExpectedTypeEvaluator.addPossibleTypes(paramIndex, parameterTypes, params[params.length - 1].isRest(), possibleResults);
        }
    }

    private static void addPossibleTypes(int paramIndex, JSFunctionTypeImpl matchedFunction, List<JSType> possibleResults) {
        if (matchedFunction != null) {
            List<JSParameterTypeDecorator> parameters = matchedFunction.getParameters();
            if (parameters.isEmpty()) {
                return;
            }
            List<JSType> parameterTypes = parameters.stream().map(JSParameterTypeDecorator::getType).collect(Collectors.toList());
            JSContextExpectedTypeEvaluator.addPossibleTypes(paramIndex, parameterTypes, parameters.get(parameters.size() - 1).isRest(), possibleResults);
        }
    }

    private static void addPossibleTypes(int paramIndex, List<JSType> params, boolean isLastRest, List<JSType> possibleResults) {
        JSType param = null;
        if (paramIndex < params.size()) {
            param = params.get(paramIndex);
        } else if (params.size() > 0 && isLastRest) {
            param = (JSType)ContainerUtil.getLastItem(params);
        }
        if (param != null) {
            possibleResults.add(param);
        }
    }

    protected JSFunctionWithSubstitutor calcFunctionForArgumentList(@NotNull JSCallExpression originalElement, PsiElement resolvedElement) {
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/lang/javascript/psi/JSContextExpectedTypeEvaluator", "calcFunctionForArgumentList"));
        }
        Collection<JSFunctionWithSubstitutor> functions = JSPsiImplUtils.calculatePossibleFunctions(resolvedElement, (PsiElement)originalElement);
        if (functions.size() == 0) {
            return null;
        }
        return DialectDetector.isTypeScript((PsiElement)originalElement) && functions.size() > 1 ? null : (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functions);
    }

    protected void postProcessType(@Nullable JSFunctionItem item, @NotNull JSReferenceExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/JSContextExpectedTypeEvaluator", "postProcessType"));
        }
    }

    public void visitJSParenthesizedExpression(JSParenthesizedExpression node) {
        JSContextExpectedTypeEvaluator parEvaluator = this.newExpectedTypeEvaluator((JSExpression)node);
        this.myResult = parEvaluator.findExpectedType();
    }

    public void visitTypeScriptCastExpression(TypeScriptCastExpression node) {
        TypeScriptType type = node.getType();
        if (type != null) {
            this.myResult = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)type);
        }
    }

    public boolean hasExplicitlyQualifierType(JSExpression methodExpr) {
        JSType type;
        JSTypeEvaluationResult expressionType;
        JSExpression qualifier;
        if (methodExpr instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)methodExpr) && (qualifier = ((JSReferenceExpression)methodExpr).getQualifier()) != null && (expressionType = JSTypeEvaluator.getExpressionType(qualifier)) != null && (type = expressionType.getType()) != null) {
            return TypeScriptUtil.isStrictType(type);
        }
        return true;
    }

    public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
        JSContextExpectedTypeEvaluator evaluator = this.newExpectedTypeEvaluator((JSExpression)node);
        JSType arrayType = evaluator.findExpectedType();
        if (arrayType != null) {
            this.myResult = JSTypeUtils.getIterableComponentType(arrayType);
        }
    }

    public void visitJSProperty(JSProperty node) {
        PsiElement parent = node.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            JSRecordType.PropertySignature propertySignature;
            JSType parentExpectedType = this.newExpectedTypeEvaluator((JSExpression)((JSObjectLiteralExpression)parent)).findExpectedType();
            parentExpectedType = JSTypeUtils.getValuableType(parentExpectedType);
            String name = node.getName();
            if (DialectDetector.isTypeScript((PsiElement)node)) {
                JSRecordType jSRecordType = parentExpectedType = parentExpectedType == null ? null : parentExpectedType.asRecordType();
            }
            if (parentExpectedType instanceof JSRecordType && name != null && (propertySignature = ((JSRecordType)parentExpectedType).findPropertySignature(name)) != null) {
                this.myResult = propertySignature.getType();
            }
        }
    }
}

