/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptPropertySignatureStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPropertySignatureImpl
extends JSQualifiedNamedElementBaseImpl<TypeScriptPropertySignatureStub>
implements TypeScriptPropertySignature {
    public static final ParameterizedCachedValueProvider<JSType, TypeScriptPropertySignature> CACHE_VALUE_PROVIDER = new ParameterizedCachedValueProvider<JSType, TypeScriptPropertySignature>(){

        @Nullable
        public CachedValueProvider.Result<JSType> compute(@NotNull TypeScriptPropertySignature param) {
            if (param == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl$1", "compute"));
            }
            JSTypeDeclaration declaration = param.getTypeDeclaration();
            if (declaration != null) {
                return CachedValueProvider.Result.create((Object)TypeScriptTypeParser.buildTypeFromTypeScript(declaration), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    public static final Key<ParameterizedCachedValue<JSType, TypeScriptPropertySignature>> CACHE_VALUE_KEY = Key.create((String)"property.signature.type");

    public TypeScriptPropertySignatureImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptPropertySignatureImpl(TypeScriptPropertySignatureStub stub, IStubElementType signature) {
        super(stub, signature);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptPropertySignature((TypeScriptPropertySignature)this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean isOptional() {
        TypeScriptPropertySignatureStub stub = (TypeScriptPropertySignatureStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        return this.findChildByType(JSTokenTypes.QUEST) != null;
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    public boolean isConst() {
        TypeScriptPropertySignatureStub stub = (TypeScriptPropertySignatureStub)this.getGreenStub();
        if (stub != null) {
            return stub.isConst();
        }
        JSAttributeList list = this.getAttributeList();
        if (list == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.READONLY);
    }

    public JSTypeDeclaration getTypeDeclaration() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSKeywordSets.PROPERTY_NAMES);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    public String getName() {
        TypeScriptPropertySignatureStub stub = (TypeScriptPropertySignatureStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptPropertySignatureStub stub = (TypeScriptPropertySignatureStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof TypeScriptObjectType) {
            parent = parent.getParent();
        }
        return parent instanceof JSQualifiedNamedElement ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSQualifiedNamedElement)parent)) : null;
    }

    @Nullable
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return false;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "getAccessType"));
        }
        return accessType;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "setName"));
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode != null) {
            ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name, nameNode.getElementType());
            this.getNode().replaceChild(nameNode, nameElement);
        }
        return this;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "processDeclarations"));
        }
        if (lastParent != null && lastParent.getParent() == this && JSPsiImplUtils.getExecutionScope(place) == JSPsiImplUtils.getExecutionScope((PsiElement)this) || lastParent == this) {
            return true;
        }
        return processor.execute((PsiElement)this, state);
    }

    @Nullable
    public Icon getIcon(int flags) {
        return TypeScriptPropertySignatureImpl.getIcon((JSPsiElementBase)this, PlatformIcons.PROPERTY_ICON, flags);
    }

    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return (ES6ComputedName)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.COMPUTED_NAME);
    }

    @NotNull
    public JSContext getJSContext() {
        TypeScriptPropertySignatureStub stub = (TypeScriptPropertySignatureStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "getJSContext"));
            }
            return jSContext;
        }
        JSContext jSContext = JSSymbolUtil.getContext(this);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "getJSContext"));
        }
        return jSContext;
    }

    @Nullable
    public JSType getType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHE_VALUE_KEY, CACHE_VALUE_PROVIDER, false, (Object)this);
    }

    @Nullable
    public PsiElement getTypeElement() {
        return this.getTypeDeclaration();
    }

    @Nullable
    public JSExpression getInitializer() {
        return null;
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, boolean allowResolve) {
        return JSRecordType.arePropertySignaturesEqual((JSRecordType.PropertySignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
    }

    @NotNull
    public String getMemberName() {
        String string = TypeScriptPsiUtil.getMemberName((JSComputedPropertyNameOwner)this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "getMemberName"));
        }
        return string;
    }

    @Nullable
    public PsiElement getSource() {
        return this;
    }

    @NotNull
    public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "copyTypeHierarchy"));
        }
        JSRecordType.PropertySignature propertySignature = JSRecordTypeImpl.copyPropertySignature((JSRecordType.PropertySignature)this, childTransform, shouldCleanSourceElement);
        if (propertySignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptPropertySignatureImpl", "copyTypeHierarchy"));
        }
        return propertySignature;
    }
}

