/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSForInStatementImpl
extends JSStatementImpl
implements JSForInStatement {
    public JSForInStatementImpl(IElementType elementType) {
        super(elementType);
    }

    public JSVarStatement getDeclarationStatement() {
        ASTNode childNode = this.getNode().findChildByType((IElementType)JSElementTypes.VAR_STATEMENT);
        return childNode == null ? null : (JSVarStatement)childNode.getPsi();
    }

    public JSExpression getVariableExpression() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD) {
                return null;
            }
            if (!JSElementTypes.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getCollectionExpression() {
        boolean inPassed = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD || child.getElementType() == JSTokenTypes.OF_KEYWORD) {
                inPassed = true;
            }
            if (!inPassed || !JSElementTypes.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public boolean isForEach() {
        return this.getNode().findChildByType(JSTokenTypes.EACH_KEYWORD) != null || this.getNode().findChildByType(JSTokenTypes.OF_KEYWORD) != null;
    }

    public JSStatement getBody() {
        boolean passedRParen = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.RPAR) {
                passedRParen = true;
                continue;
            }
            if (!passedRParen || !JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(child.getElementType())) continue;
            return (JSStatement)child.getPsi();
        }
        return null;
    }

    public JSExpression getCondition() {
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSForInStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSForInStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSForInStatementImpl", "processDeclarations"));
        }
        if (lastParent != null) {
            JSVarStatement statement = this.getDeclarationStatement();
            if (statement != null) {
                return statement.processDeclarations(processor, state, lastParent, place);
            }
            JSExpression expression = this.getVariableExpression();
            if (expression != null && !processor.execute((PsiElement)expression, state)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSForInStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSForInStatement((JSForInStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

