/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptAttributeListImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPsiImplUtils {
    public static final String CONSTRUCTS_PROPERTY_NAME = "construct";
    @NonNls
    private static final String ARRAY_ELEMENT_TYPE_ANNOTATION_NAME = "ArrayElementType";
    public static final Function<JSFunctionItem, JSFunctionWithSubstitutor> TO_FUNCTION_WITH_SUBSTITUTOR = fun -> new JSFunctionWithSubstitutor((JSFunctionItem)fun, null);
    public static final Function<JSFunctionItem, Collection<JSFunctionWithSubstitutor>> TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR = fun -> fun == null ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)new JSFunctionWithSubstitutor((JSFunctionItem)fun, null));
    private static final Pattern ourQuotedQualifiedNamePartPattern = Pattern.compile("[^\\.\"']+|\"([^\"\\\\]|\\\\.)*\"|'([^'\\\\]|\\\\.)*'");
    public static final TObjectHashingStrategy<JSQualifiedNamedElement> QUALIFIED_NAME_HASHING_STRATEGY = new TObjectHashingStrategy<JSQualifiedNamedElement>(){

        public int computeHashCode(JSQualifiedNamedElement object) {
            return object == null || object.getQualifiedName() == null ? 0 : object.getQualifiedName().hashCode();
        }

        public boolean equals(JSQualifiedNamedElement o1, JSQualifiedNamedElement o2) {
            return Comparing.equal((String)o1.getQualifiedName(), (String)o2.getQualifiedName());
        }
    };
    private static TokenSet FUNCTION_NAME_PREFIX_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD});
    private static final ResolveProcessor.ProcessingOptions ourNsProcessingOptions = new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions(){

        @Override
        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null;
        }
    };
    private static final TokenSet OBJECT_LITERAL_EXPRESSION_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION});
    private static final TokenSet FIND_CONSTRUCTS_STOP_AT = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, OBJECT_LITERAL_EXPRESSION_TOKEN_SET});

    @Nullable
    public static ASTNode getTypeExpressionFromDeclaration(JSElement element) {
        ASTNode node;
        ASTNode myNode = element.getNode();
        Object object = element instanceof TypeScriptFunctionType ? myNode.findChildByType(JSTokenTypes.EQGT) : (node = myNode != null ? myNode.findChildByType(JSTokenTypes.COLON) : null);
        if (node != null) {
            return myNode.findChildByType(JSDocumentationUtils.ourTypeFilter, node);
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromTypeExpr(@Nullable ASTNode typeExpr, JSElement element) {
        if (typeExpr == null) {
            return null;
        }
        PsiElement typePsi = typeExpr.getPsi();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)(typePsi instanceof JSTypeDeclaration ? typePsi : element), true);
        JSType type = JSTypeUtils.createType(typeExpr.getText(), typeSource);
        if (type instanceof JSPrimitiveArrayType || type instanceof JSDecoratedTypeImpl && ((JSDecoratedTypeImpl)type).getType() instanceof JSAnyType) {
            String arrayType;
            JSAttributeListOwner attributeListOwner;
            JSAttributeList attributeList;
            String elementType;
            PsiComment psiComment = null;
            PsiElement el = typePsi.getPrevSibling();
            if (el instanceof PsiWhiteSpace) {
                el = el.getPrevSibling();
            }
            if (el instanceof PsiComment) {
                psiComment = (PsiComment)el;
            }
            if (psiComment != null && !(psiComment instanceof JSDocComment) && !(elementType = JSDocumentationUtils.unwrapCommentDelimiters(psiComment.getText()).trim()).isEmpty()) {
                JSType baseType = JSTypeUtils.createType(elementType, typeSource);
                if (type instanceof JSPrimitiveArrayType) {
                    return new JSArrayTypeImpl(baseType, typeSource);
                }
                return baseType;
            }
            if (element instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)element).getAttributeList()) != null && (arrayType = JSPsiImplUtils.getArrayElementTypeFromAnnotation(attributeList)) != null && !arrayType.isEmpty()) {
                JSType baseType = JSTypeUtils.createType(arrayType, typeSource);
                if (type instanceof JSPrimitiveArrayType) {
                    return new JSArrayTypeImpl(baseType, typeSource);
                }
                return baseType;
            }
        }
        return type;
    }

    @Nullable
    public static JSType getTypeFromDeclaration(JSElement element) {
        ASTNode typeExpr = JSPsiImplUtils.getTypeExpressionFromDeclaration(element);
        return JSPsiImplUtils.getTypeFromTypeExpr(typeExpr, element);
    }

    @Nullable
    public static JSTypeDeclaration getTypeElementFromDeclaration(JSElement element) {
        PsiElement psi;
        if (DialectDetector.isTypeScript((PsiElement)element) && element instanceof StubBasedPsiElementBase) {
            return TypeScriptPsiUtil.getStubOrPsiTypeElement((StubBasedPsiElementBase)element);
        }
        ASTNode typeNode = JSPsiImplUtils.getTypeExpressionFromDeclaration(element);
        if (typeNode != null && (psi = typeNode.getPsi()) instanceof JSTypeDeclaration) {
            return (JSTypeDeclaration)psi;
        }
        return null;
    }

    @Nullable
    public static String getArrayElementTypeFromAnnotation(JSAttributeList attributeList) {
        String type = JSPsiImplUtils.getTypeFromAnnotationParameter(attributeList, ARRAY_ELEMENT_TYPE_ANNOTATION_NAME, null);
        return type != null ? type : JSPsiImplUtils.getTypeFromAnnotationParameter(attributeList, ARRAY_ELEMENT_TYPE_ANNOTATION_NAME, "elementType");
    }

    public static void updateFileName(JSQualifiedNamedElement jsClassBase, String newName, String oldName) throws IncorrectOperationException {
        VirtualFile virtualFile;
        PsiFile containingFile = jsClassBase.getContainingFile();
        if (containingFile.getContext() == null && (virtualFile = containingFile.getVirtualFile()) != null && virtualFile.getNameWithoutExtension().equals(oldName)) {
            String s = containingFile.getName();
            containingFile.setName(newName + "." + s.substring(s.lastIndexOf(46) + 1));
        }
    }

    @Nullable
    public static JSPackageStatement findPackageStatement(JSFile file) {
        JSPackageStatement packageStatement = null;
        for (JSSourceElement statement : file.getStatements()) {
            if (!(statement instanceof JSPackageStatement)) continue;
            packageStatement = (JSPackageStatement)statement;
            break;
        }
        return packageStatement;
    }

    @Nullable
    public static JSClass findClass(JSFile file) {
        JSQualifiedNamedElement element = JSPsiImplUtils.findQualifiedElement(file);
        return element instanceof JSClass ? (JSClass)element : null;
    }

    @Nullable
    public static JSQualifiedNamedElement findQualifiedElement(JSFile file) {
        JSNamedElement mainDeclaredElement = ActionScriptResolveUtil.findMainDeclaredElement((PsiFileImpl)file);
        return mainDeclaredElement instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)mainDeclaredElement : null;
    }

    @NotNull
    public static PsiElement findTopLevelNavigatableElement(@NotNull JSQualifiedNamedElement jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findTopLevelNavigatableElement"));
        }
        if (DumbService.getInstance((Project)jsClass.getProject()).isDumb()) {
            JSQualifiedNamedElement jSQualifiedNamedElement = jsClass;
            if (jSQualifiedNamedElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findTopLevelNavigatableElement"));
            }
            return jSQualifiedNamedElement;
        }
        PsiElement sourceElement = JSPsiImplUtils.findTopLevelNavigatableElementWithSource(jsClass, null);
        if (sourceElement != null) {
            PsiElement psiElement = sourceElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findTopLevelNavigatableElement"));
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = jsClass;
        if (jSQualifiedNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findTopLevelNavigatableElement"));
        }
        return jSQualifiedNamedElement;
    }

    @Nullable
    public static PsiElement findTopLevelNavigatableElementWithSource(@NotNull JSQualifiedNamedElement jsClass, @Nullable Consumer<JSQualifiedNamedElement> candidatesConsumer) {
        ProjectFileIndex fileIndex;
        PsiFile containingFile;
        VirtualFile vFile;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findTopLevelNavigatableElementWithSource"));
        }
        if (candidatesConsumer != null) {
            candidatesConsumer.consume((Object)jsClass);
        }
        VirtualFile virtualFile = vFile = (containingFile = jsClass.getContainingFile()) == null ? null : containingFile.getVirtualFile();
        if (vFile != null && ((fileIndex = ProjectRootManager.getInstance((Project)jsClass.getProject()).getFileIndex()).isInSourceContent(vFile) || fileIndex.isInLibrarySource(vFile))) {
            return jsClass;
        }
        PsiElement sourceElement = JSPsiImplUtils.findNavigatableElementForLibraryClass(jsClass);
        if (sourceElement != null) {
            return sourceElement;
        }
        GlobalSearchScope searchScope = JSResolveUtil.getResolveScope((PsiElement)jsClass);
        String qName = jsClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)jsClass.getProject(), (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            if (qName.equals(((JSQualifiedNamedElement)i.next()).getQualifiedName())) continue;
            i.remove();
        }
        for (JSQualifiedNamedElement candidate : candidates) {
            PsiElement candidateSourceElement;
            if (candidate == jsClass) continue;
            if (candidatesConsumer != null) {
                candidatesConsumer.consume((Object)candidate);
            }
            if ((candidateSourceElement = JSPsiImplUtils.findNavigatableElementForLibraryClass(candidate)) == null) continue;
            return candidateSourceElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement findNavigatableElementForLibraryClass(JSQualifiedNamedElement jsClass) {
        PsiFile containingFile = jsClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile vFile = containingFile.getVirtualFile();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)jsClass.getProject()).getFileIndex();
        if (vFile == null || projectFileIndex.getClassRootForFile(vFile) == null) {
            return null;
        }
        List orderEntries = projectFileIndex.getOrderEntriesForFile(vFile);
        String qName = jsClass.getQualifiedName();
        String baseSourceName = jsClass.getName();
        String packageName = StringUtil.getPackageName((String)qName);
        String relativeFilePath = packageName.isEmpty() ? baseSourceName : packageName.replace('.', '/') + '/' + baseSourceName;
        String relativeFilePath2 = relativeFilePath + ".mxml";
        String relativeFilePath4 = relativeFilePath + ".fxg";
        relativeFilePath = relativeFilePath + ".as";
        for (OrderEntry orderEntry : orderEntries) {
            VirtualFile[] files;
            for (VirtualFile file : files = JSPsiImplUtils.getSourceRoots(orderEntry, vFile)) {
                PsiFile psiSource;
                VirtualFile source = file.findFileByRelativePath(relativeFilePath);
                if (source != null) {
                    psiSource = jsClass.getManager().findFile(source);
                    if (!(psiSource instanceof JSFile)) continue;
                    JSPackageStatement statement = JSPsiImplUtils.findPackageStatement((JSFile)psiSource);
                    if (statement != null) {
                        for (JSSourceElement el : statement.getStatements()) {
                            if (el.getClass() == jsClass.getClass() && jsClass.getName().equals(el.getName())) {
                                return el;
                            }
                            if (!(jsClass instanceof JSVariable) || !(el instanceof JSNamespaceDeclaration) || !Comparing.equal((String)jsClass.getQualifiedName(), (String)((JSNamespaceDeclaration)el).getQualifiedName())) continue;
                            return el;
                        }
                    }
                    return psiSource;
                }
                source = file.findFileByRelativePath(relativeFilePath2);
                if (source == null) {
                    source = file.findFileByRelativePath(relativeFilePath4);
                }
                if (source == null || !((psiSource = jsClass.getManager().findFile(source)) instanceof XmlFile)) continue;
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiSource);
            }
        }
        return null;
    }

    private static VirtualFile[] getSourceRoots(OrderEntry orderEntry, VirtualFile vFile) {
        if (orderEntry instanceof ModuleJdkOrderEntry) {
            Sdk sdk = ((ModuleJdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            if (sdk instanceof CompositeRootCollection) {
                return ((CompositeRootCollection)sdk).getFiles(OrderRootType.SOURCES, vFile);
            }
        }
        return orderEntry.getFiles(OrderRootType.SOURCES);
    }

    @Nullable
    public static JSQualifiedName getNamespace(@NotNull JSNamedElement element) {
        PsiElement responsibleParent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getNamespace"));
        }
        PsiElement nameIdentifier = element.getNameIdentifier();
        String name = nameIdentifier != null ? nameIdentifier.getText() : null;
        JSQualifiedName result = null;
        if (name != null && StringUtil.containsChar((String)name, (char)'.')) {
            Matcher matcher = ourQuotedQualifiedNamePartPattern.matcher(name);
            while (matcher.find()) {
                result = JSQualifiedNameImpl.create(matcher.group(0), result);
            }
            if (result != null) {
                result = result.getParent();
            }
        }
        if ((responsibleParent = element.getParent()) instanceof JSVarStatement) {
            responsibleParent = responsibleParent.getParent();
        }
        if (responsibleParent instanceof JSPackageStatement || responsibleParent instanceof TypeScriptModule || responsibleParent instanceof JSClass && !DialectDetector.isActionScript(responsibleParent)) {
            JSQualifiedName prefix = JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSQualifiedNamedElement)responsibleParent));
            result = JSQualifiedNameImpl.fromQualifiedNames(prefix, result);
        }
        return result;
    }

    @Nullable
    public static String buildQualifiedNameFromNamespaceAndName(JSQualifiedNamedElement element) {
        String result = element.getName();
        if (result == null) {
            return null;
        }
        JSQualifiedName namespace = element.getNamespace();
        if (namespace != null) {
            result = namespace.getQualifiedName() + "." + result;
        }
        return result;
    }

    @Nullable
    public static JSQualifiedName buildNamespaceFromQualifiedName(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "buildNamespaceFromQualifiedName"));
        }
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        Matcher matcher = ourQuotedQualifiedNamePartPattern.matcher(qualifiedName);
        JSQualifiedNameImpl result = null;
        while (matcher.find()) {
            result = JSQualifiedNameImpl.create(matcher.group(0), result);
        }
        return result != null ? result.getParent() : null;
    }

    @Nullable
    public static ASTNode findAnnotationAttributeValueNode(ASTNode node) {
        ASTNode valueNode = node.findChildByType(JSTokenTypes.STRING_LITERAL);
        if (valueNode == null) {
            valueNode = node.findChildByType(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL);
        }
        if (valueNode == null) {
            ASTNode next;
            ASTNode eqNode = node.findChildByType(JSTokenTypes.EQ);
            ASTNode aSTNode = next = eqNode == null ? null : eqNode.getTreeNext();
            while (next != null && next.getElementType() == JSTokenTypes.WHITE_SPACE) {
                next = next.getTreeNext();
            }
            valueNode = next;
        }
        return valueNode;
    }

    @Nullable
    public static String getTypeFromAnnotationParameter(@NotNull JSAttributeList attributeList, @NotNull String annotationName, @Nullable String annotationParameter) {
        if (attributeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeList", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getTypeFromAnnotationParameter"));
        }
        if (annotationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationName", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getTypeFromAnnotationParameter"));
        }
        String arrayType = null;
        JSAttribute[] byName = attributeList.getAttributesByName(annotationName);
        if (byName.length > 0) {
            JSAttributeNameValuePair jsAttributeNameValuePair = byName[0].getValueByName(annotationParameter);
            arrayType = jsAttributeNameValuePair != null ? jsAttributeNameValuePair.getSimpleValue() : null;
        }
        return arrayType;
    }

    public static boolean isTheSameClass(PsiElement typeSource, JSQualifiedNamedElement jsClass) {
        VirtualFile virtualFile2;
        boolean sameQNames;
        if (typeSource == jsClass) {
            return true;
        }
        if (!(typeSource instanceof JSClass) || !(jsClass instanceof JSClass)) {
            return false;
        }
        String qName = ((JSClass)typeSource).getQualifiedName();
        boolean bl = sameQNames = qName != null && qName.equals(jsClass.getQualifiedName());
        if (!sameQNames) {
            return false;
        }
        typeSource = typeSource.getNavigationElement();
        jsClass = (JSClass)jsClass.getNavigationElement();
        PsiFile psiFile1 = typeSource.getContainingFile();
        PsiFile psiFile2 = jsClass.getContainingFile();
        VirtualFile virtualFile1 = psiFile1.getVirtualFile();
        if (Comparing.equal((Object)virtualFile1, (Object)(virtualFile2 = psiFile2.getVirtualFile()))) {
            return true;
        }
        if (JSResolveUtil.isFromPredefinedFile(psiFile1) || JSResolveUtil.isFromPredefinedFile(psiFile2) || !virtualFile1.isValid() || !virtualFile2.isValid()) {
            return true;
        }
        DirectoryIndex index = DirectoryIndex.getInstance((Project)jsClass.getProject());
        VirtualFile parent1 = virtualFile1.getParent();
        VirtualFile parent2 = virtualFile2.getParent();
        if (parent1 == null || parent2 == null) {
            return true;
        }
        DirectoryInfo info1 = index.getInfoForFile(parent1);
        DirectoryInfo info2 = index.getInfoForFile(parent2);
        if (!info1.isInProject(virtualFile1) || !info2.isInProject(virtualFile2)) {
            return false;
        }
        return info1.getModule() == null || info2.getModule() == null;
    }

    public static void doRenameParentDirectoryIfNeeded(VirtualFile file, String name, Object requestor) throws IOException {
        VirtualFile directory;
        VirtualFile virtualFile = directory = file.isDirectory() ? file : file.getParent();
        if (!name.equals(directory.getName())) {
            directory.rename(requestor, name);
        }
    }

    @Nullable
    public static String getQNameForMove(@NotNull PsiElement targetElement, PsiElement elementToBind) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getQNameForMove"));
        }
        Project project = targetElement.getProject();
        if (elementToBind instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)elementToBind).getDirectories(targetElement.getResolveScope());
            return directories.length > 0 ? JSResolveUtil.getExpectedPackageNameFromFile(directories[0].getVirtualFile(), project) : null;
        }
        String qName = null;
        if (elementToBind instanceof PsiFile) {
            String newName = ((PsiNamedElement)elementToBind).getName();
            int index = newName.lastIndexOf(46);
            if (index != -1) {
                newName = newName.substring(0, index);
            }
            VirtualFile elementToBindFile = elementToBind.getContainingFile().getVirtualFile();
            String packageName = JSResolveUtil.getExpectedPackageNameFromFile(elementToBindFile, project);
            qName = JSPackageIndex.buildQualifiedName(packageName, newName);
        } else if (elementToBind instanceof JSQualifiedNamedElement && JSUtils.getMemberContainingClass(elementToBind) == null) {
            qName = ((JSQualifiedNamedElement)elementToBind).getQualifiedName();
        }
        if (qName != null && targetElement instanceof JSReferenceExpression) {
            String targetElementPackageName;
            if (targetElement.getContainingFile() instanceof JSFile && PsiTreeUtil.getParentOfType((PsiElement)targetElement, JSPackageStatement.class) == null && JSResolveUtil.getXmlBackedClass((JSFile)targetElement.getContainingFile()) == null) {
                targetElementPackageName = "";
            } else {
                JSExpression qualifier = ((JSReferenceExpression)targetElement).getQualifier();
                String string = targetElementPackageName = qualifier != null ? qualifier.getText() : JSResolveUtil.getExpectedPackageNameFromFile(targetElement.getContainingFile().getVirtualFile(), project);
            }
            if (!JSPsiImplUtils.differentPackageName(targetElementPackageName, StringUtil.getPackageName((String)qName))) {
                return null;
            }
        }
        return qName;
    }

    public static boolean differentPackageName(String s, String expectedPackageNameFromFile) {
        boolean sIsEmpty = JSPsiImplUtils.isEmpty(s);
        boolean expectedIsEmpty = JSPsiImplUtils.isEmpty(expectedPackageNameFromFile);
        return sIsEmpty && !expectedIsEmpty || !sIsEmpty && (expectedIsEmpty || !s.equals(expectedPackageNameFromFile));
    }

    public static boolean isEmpty(String expectedPackageNameFromFile) {
        return expectedPackageNameFromFile == null || expectedPackageNameFromFile.isEmpty();
    }

    public static boolean isDeprecatedFromAttribute(JSAttributeListOwner owder) {
        JSAttribute deprecatedAttr;
        JSAttributeList attributeList = owder.getAttributeList();
        return attributeList != null && (deprecatedAttr = attributeList.findAttributeByName("Deprecated")) != null;
    }

    public static boolean containsEquivalent(Collection<? extends PsiElement> array, PsiElement element) {
        for (PsiElement psiElement : array) {
            if (!psiElement.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsEquivalent(PsiElement[] array, PsiElement element) {
        return JSPsiImplUtils.containsEquivalent(Arrays.asList(array), element);
    }

    @Nullable
    public static ASTNode findNameIdentifierOfFunction(ASTNode myNode) {
        return JSPsiImplUtils.findNameIdentifierOfFunction(myNode, false);
    }

    @Nullable
    public static ASTNode findNameIdentifierOfFunction(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        ASTNode computed = myNode.findChildByType((IElementType)ES6ElementTypes.COMPUTED_NAME);
        if (computed != null && DialectDetector.isES6(myNode.getPsi()) && (!onlyAfterMarkerKeyword || TreeUtil.findSiblingBackward((ASTNode)computed.getTreePrev(), (TokenSet)FUNCTION_NAME_PREFIX_KEYWORDS) != null)) {
            return null;
        }
        for (ASTNode candidate = myNode.findChildByType(JSElementTypes.PARAMETER_LISTS); candidate != null; candidate = candidate.getTreePrev()) {
            if (!JSKeywordSets.PROPERTY_NAMES.contains(candidate.getElementType())) continue;
            if (onlyAfterMarkerKeyword && TreeUtil.findSiblingBackward((ASTNode)candidate.getTreePrev(), (TokenSet)FUNCTION_NAME_PREFIX_KEYWORDS) == null) {
                return null;
            }
            return candidate;
        }
        return null;
    }

    @Nullable
    public static ASTNode getComputedNameOfFunction(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        ASTNode computed = myNode.findChildByType((IElementType)ES6ElementTypes.COMPUTED_NAME);
        if (computed != null && DialectDetector.isES6(myNode.getPsi()) && (!onlyAfterMarkerKeyword || TreeUtil.findSiblingBackward((ASTNode)computed.getTreePrev(), (TokenSet)FUNCTION_NAME_PREFIX_KEYWORDS) != null)) {
            return computed;
        }
        return null;
    }

    public static boolean isFunctionNameReference(JSFunction function, PsiElement elt) {
        return function.getNameIdentifier() == elt || function instanceof JSFunctionExpression && ((JSFunctionExpression)function).getOwnNameIdentifier() == elt;
    }

    public static void deleteFromTree(PsiElement element) {
        PsiComment docComment = JSDocumentationUtils.findDocComment(element);
        element.getNode().getTreeParent().removeChild(element.getNode());
        if (docComment != null && docComment.getNode().getElementType() == JSTokenTypes.DOC_COMMENT && docComment.isValid()) {
            docComment.delete();
        }
    }

    @Nullable
    public static String calcNamespaceReference(PsiElement element) {
        JSReferenceExpression namespaceElement;
        String nsName = null;
        PsiElement startFrom = null;
        if (element instanceof ActionScriptAttributeListImpl) {
            String s = ((ActionScriptAttributeListImpl)element).tryResolveNamespaceValueFromStub();
            if (s != null) {
                return s;
            }
            nsName = ((JSAttributeList)element).getNamespace();
            startFrom = JSResolveUtil.findParent(element.getParent());
        } else if (element instanceof JSReferenceExpression) {
            namespaceElement = ((JSReferenceExpression)element).getNamespaceElement();
            if (namespaceElement == null) {
                return null;
            }
            nsName = namespaceElement.getReferencedName();
        } else if (element instanceof JSUseNamespaceDirective) {
            namespaceElement = ((JSUseNamespaceDirective)element).getNamespaceReference();
            if (namespaceElement == null) {
                return null;
            }
            nsName = namespaceElement.getReferencedName();
        }
        if (nsName == null) {
            return null;
        }
        final Ref nsValueCalculated = new Ref();
        JSResolveUtil.StructureResolveProcessor processor = new JSResolveUtil.StructureResolveProcessor(nsName){
            {
                super(name);
                this.setLocalResolve(false);
                this.setForceImportsForPlace(true);
                this.setProcessingOptions(ourNsProcessingOptions);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils$3", "execute"));
                }
                String nsValue = null;
                if (element instanceof JSNamespaceDeclaration) {
                    nsValue = ((JSNamespaceDeclaration)element).getInitialValueString();
                    if (nsValue == null) {
                        nsValue = ((JSNamespaceDeclaration)element).getName();
                    }
                } else if (element instanceof JSVariable) {
                    JSVariable var = (JSVariable)element;
                    nsValue = var.isConst() ? var.getLiteralOrReferenceInitializerText() : "-\"-";
                }
                if (nsValue != null) {
                    nsValueCalculated.set((Object)StringUtil.stripQuotesAroundValue((String)nsValue));
                    return false;
                }
                return true;
            }
        };
        PsiElement context = startFrom != null ? startFrom : element;
        JSResolveUtil.walkOverStructure(context, processor);
        String result = (String)nsValueCalculated.get();
        if ("-\"-".equals(result)) {
            return null;
        }
        if (result == null) {
            result = nsName;
        }
        return result;
    }

    public static boolean isArrowFunction(@Nullable JSFunction function) {
        return JSPsiImplUtils.getFunctionArrowNode(function) != null;
    }

    @Nullable
    public static ASTNode getFunctionArrowNode(@Nullable JSFunction function) {
        if (!(function instanceof JSFunctionExpression)) {
            return null;
        }
        return function.getNode().findChildByType(JSTokenTypes.ARROWS);
    }

    @Nullable
    public static JSExpression tryGetArrowFunctionReturnExpression(@Nullable JSFunction function) {
        if (JSPsiImplUtils.getFunctionArrowNode(function) == null) {
            return null;
        }
        ASTNode expressionNode = function.getNode().findChildByType(JSElementTypes.EXPRESSIONS);
        return expressionNode != null ? (JSExpression)expressionNode.getPsi() : null;
    }

    @Nullable
    public static PsiElement getNonParenthesizeParent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getNonParenthesizeParent"));
        }
        return JSUtils.getParentSkipParentheses(element);
    }

    public static boolean isTypeSignature(@Nullable JSFunction function) {
        return function instanceof TypeScriptType || function instanceof TypeScriptTypeMember;
    }

    @Nullable
    public static JSFunction getPossibleFunction(@Nullable PsiElement element) {
        if (element instanceof JSFunction) {
            return (JSFunction)element;
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).tryGetFunctionExpressionInitializer();
        }
        if (element instanceof JSVariable) {
            return ((JSVariable)element).tryGetFunctionExpressionInitializer();
        }
        if (element instanceof JSProperty) {
            return ((JSProperty)element).tryGetFunctionInitializer();
        }
        return null;
    }

    @Nullable
    public static JSFunctionItem getPossibleFunctionItem(@Nullable PsiElement element) {
        if (element instanceof JSFunctionItem) {
            return (JSFunctionItem)element;
        }
        return JSPsiImplUtils.getPossibleFunction(element);
    }

    @Deprecated
    @Nullable
    public static JSFunctionItem calculatePossibleFunction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunction"));
        }
        return JSPsiImplUtils.calculatePossibleFunction(element, null);
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunction(@NotNull PsiElement element, @Nullable PsiElement methodExpression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunction"));
        }
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors = JSPsiImplUtils.calculatePossibleFunctions(element, methodExpression, null);
        if (functionWithSubstitutors.isEmpty()) {
            return null;
        }
        JSFunctionWithSubstitutor item = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functionWithSubstitutors);
        if (item != null) {
            JSFunctionItem firstFunction = item.myFunctionItem;
            JSTypeSubstitutor substitutor = item.myTypeSubstitutor;
            if (firstFunction instanceof JSImplicitFunctionImpl) {
                return firstFunction;
            }
            return functionWithSubstitutors.size() > 1 || substitutor != null ? null : firstFunction;
        }
        return null;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
        }
        Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.calculatePossibleFunctions(element, methodExpression, null);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited) {
        Collection implicitElements;
        JSElementIndexingData data;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
        }
        if (visited != null && visited.contains(element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
            }
            return list;
        }
        boolean isTypeScript = DialectDetector.isTypeScript(element);
        if ((element = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element, visited, (Processor<PsiElement>)(!isTypeScript ? null : el -> {
            if (DialectDetector.isTypeScript(el) && el instanceof JSTypeDeclarationOwner) {
                return ((JSTypeDeclarationOwner)el).getTypeElement() == null;
            }
            return true;
        }))) instanceof JSFunctionItem) {
            JSFunctionItem function = ((JSFunctionItem)element).isGetProperty() ? null : (JSFunctionItem)element;
            Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(function);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
            }
            return collection;
        }
        if (element instanceof JSVariable) {
            JSFunctionExpression initializer;
            if (!(isTypeScript && ((JSVariable)element).getTypeElement() != null || (initializer = ((JSVariable)element).tryGetFunctionExpressionInitializer()) == null)) {
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(element);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
            if (isTypeScript) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptPsiUtil.calculatePossibleFunctionForVariable((JSFieldVariable)((JSVariable)element), methodExpression, visited);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
        } else if (element instanceof JSField) {
            if (isTypeScript) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptPsiUtil.calculatePossibleFunctionForVariable((JSFieldVariable)((JSField)element), methodExpression, visited);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
        } else if (element instanceof JSProperty) {
            JSFunction value = ((JSProperty)element).tryGetFunctionInitializer();
            if (value != null) {
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)value);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
        } else if (element instanceof JSDefinitionExpression) {
            JSFunctionExpression functionExpression = ((JSDefinitionExpression)element).tryGetFunctionExpressionInitializer();
            if (functionExpression != null) {
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)functionExpression);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(element);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
        } else if (element instanceof JSImplicitElement) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSLiteralExpressionImpl) {
                JSFunction function;
                JSProperty property;
                JSObjectLiteralExpression nextArgument = null;
                JSLiteralExpressionStub stub = (JSLiteralExpressionStub)((JSLiteralExpressionImpl)parent).getStub();
                if (stub != null) {
                    StubElement nextSibling = StubTreeUtil.getNextSibling(stub);
                    if (nextSibling instanceof JSObjectLiteralExpressionStub) {
                        nextArgument = (JSObjectLiteralExpression)((JSObjectLiteralExpressionStub)nextSibling).getPsi();
                    }
                } else {
                    JSExpression[] arguments;
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof JSArgumentList && (arguments = ((JSArgumentList)grandParent).getArguments()).length == 2 && arguments[0] == parent && arguments[1] instanceof JSObjectLiteralExpression) {
                        nextArgument = (JSObjectLiteralExpression)arguments[1];
                    }
                }
                if (nextArgument != null && (property = nextArgument.findProperty(CONSTRUCTS_PROPERTY_NAME)) != null && (function = property.tryGetFunctionInitializer()) != null) {
                    Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)function);
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                    }
                    return collection;
                }
            } else if (parent instanceof JSDocComment) {
                JSFunctionExpression constructsFunction;
                PsiElement associatedElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)parent);
                JSFunctionExpression jSFunctionExpression = constructsFunction = associatedElement != null ? JSPsiImplUtils.findConstructsFunction(associatedElement) : null;
                if (constructsFunction != null) {
                    Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                    }
                    return collection;
                }
            }
        } else if (element instanceof TypeScriptClass) {
            if (methodExpression != null) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptUtil.resolveConstructorFunctions((TypeScriptClass)element, methodExpression);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
        } else {
            if (element instanceof ES6Class) {
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((ES6Class)element).getConstructor());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
            if (element instanceof TypeScriptImportStatement) {
                Collection elements = ((TypeScriptImportStatement)element).findReferencedElements();
                if (visited == null) {
                    visited = new THashSet();
                }
                visited.add((PsiElement)element);
                ArrayList result = ContainerUtil.newArrayList();
                for (PsiElement psiElement : elements) {
                    result.addAll(JSPsiImplUtils.calculatePossibleFunctions(psiElement, methodExpression, (Set<PsiElement>)visited));
                }
                ArrayList arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return arrayList;
            }
        }
        if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!(implicitElement instanceof JSImplicitFunctionImpl)) continue;
                Collection<JSFunctionWithSubstitutor> collection = TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSImplicitFunctionImpl)implicitElement);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "calculatePossibleFunctions"));
        }
        return list;
    }

    @Nullable
    public static JSFunctionExpression findConstructsFunction(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findConstructsFunction"));
        }
        PsiElement scope = element;
        if (element instanceof JSDefinitionExpression && (parent = element.getParent()) instanceof JSAssignmentExpression) {
            scope = parent;
        }
        Collection<Object> objectLiterals = scope instanceof JSObjectLiteralExpression ? Collections.singleton((JSObjectLiteralExpression)scope) : JSStubBasedPsiTreeUtil.findDescendants(scope, OBJECT_LITERAL_EXPRESSION_TOKEN_SET, FIND_CONSTRUCTS_STOP_AT);
        for (JSObjectLiteralExpression jSObjectLiteralExpression : objectLiterals) {
            for (JSProperty property : jSObjectLiteralExpression.getProperties()) {
                JSFunction initializer;
                JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property);
                if (comment == null || !comment.hasConstructsTag() || !((initializer = property.tryGetFunctionInitializer()) instanceof JSFunctionExpression)) continue;
                return (JSFunctionExpression)initializer;
            }
        }
        return null;
    }

    @Nullable
    public static JSExpression getAssignedExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getAssignedExpression"));
        }
        if (element instanceof JSDefinitionExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getLOperand() == element) {
                JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
                return rOperand != null ? JSPsiImplUtils.getAssignedExpression((PsiElement)rOperand) : null;
            }
        } else {
            if (element instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)element).getROperand();
                return rOperand != null ? JSPsiImplUtils.getAssignedExpression((PsiElement)rOperand) : null;
            }
            if (element instanceof JSExpression) {
                return (JSExpression)element;
            }
            if (element instanceof JSVariable) {
                return ((JSVariable)element).getInitializer();
            }
            if (element instanceof JSProperty) {
                return ((JSProperty)element).getValue();
            }
        }
        return null;
    }

    @Nullable
    public static String findFunctionQualifiedName(@NotNull JSFunctionItem function) {
        JSExpression lOperand;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findFunctionQualifiedName"));
        }
        String qualifiedName = function.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        if (!(function instanceof JSExpression)) {
            return null;
        }
        JSExpression expression = (JSExpression)function;
        PsiElement parent = expression.getParent();
        if (parent instanceof JSVariable) {
            return ((JSVariable)parent).getQualifiedName();
        }
        if (parent instanceof JSProperty) {
            return ((JSProperty)parent).getName();
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)lOperand).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String findFunctionName(@NotNull JSFunctionItem function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findFunctionName"));
        }
        String qualifiedName = JSPsiImplUtils.findFunctionQualifiedName(function);
        return qualifiedName != null ? QualifiedName.fromDottedString((String)qualifiedName).getLastComponent() : null;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static PsiElement findPrevCodeElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findPrevCodeElement"));
        }
        PsiElement prev = element;
        while ((prev = prev.getPrevSibling()) instanceof PsiWhiteSpace || prev instanceof PsiComment) {
        }
        return prev;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static PsiElement findNextCodeElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findNextCodeElement"));
        }
        PsiElement next = element;
        while ((next = next.getNextSibling()) instanceof PsiWhiteSpace || next instanceof PsiComment) {
        }
        return next;
    }

    @Nullable
    public static JSFunction getScopeFunction(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getScopeFunction"));
        }
        return (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
    }

    public static boolean isGetProperty(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "isGetProperty"));
        }
        return element instanceof JSFunction ? ((JSFunction)element).isGetProperty() : element instanceof JSProperty && ((JSProperty)element).isGetProperty();
    }

    @Nullable
    public static PsiElement getExecutionScope(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getExecutionScope"));
        }
        for (parent = element.getContext(); !(parent instanceof PsiFile || parent == null || parent instanceof JSExecutionScope || parent instanceof JSClass || parent instanceof JSPackageStatement || parent instanceof JSPackage); parent = parent.getContext()) {
        }
        return parent;
    }

    @Nullable
    public static JSExpression getRightmostOperand(@NotNull JSDefinitionExpression definitionExpression) {
        if (definitionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionExpression", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getRightmostOperand"));
        }
        PsiElement parent = definitionExpression.getParent();
        if (parent instanceof JSAssignmentExpression) {
            JSExpression expr = ((JSAssignmentExpression)parent).getROperand();
            while (expr instanceof JSAssignmentExpression) {
                expr = ((JSAssignmentExpression)expr).getROperand();
            }
            return expr;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement getNextSiblingIgnoreWhitespace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement nextSibling = element.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement getPrevSiblingIgnoreWhitespace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @NotNull
    public static JSAttributeList.AccessType getAccessType(JSQualifiedNamedElement element) {
        JSAttributeList.AccessType accessType;
        JSAttributeList.AccessType accessType2;
        JSAttributeList list;
        JSAttributeList jSAttributeList = list = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (list != null && (accessType2 = list.getExplicitAccessType()) != null) {
            JSAttributeList.AccessType accessType3 = accessType2;
            if (accessType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getAccessType"));
            }
            return accessType3;
        }
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        if (docComment != null && (accessType = docComment.getAccessType()) != null) {
            JSAttributeList.AccessType accessType4 = accessType;
            if (accessType4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getAccessType"));
            }
            return accessType4;
        }
        if (element instanceof JSFunction || element instanceof JSVariable) {
            String name = element.getName();
            JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
            if (parentFunction != null && element.getNamespace() == null && name != null && !JSTreeUtil.findReturnedReferences((CompositeElement)parentFunction.getNode()).contains(name)) {
                JSAttributeList.AccessType accessType5 = JSAttributeList.AccessType.PRIVATE;
                if (accessType5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getAccessType"));
                }
                return accessType5;
            }
        }
        JSAttributeList.AccessType accessType6 = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getAccessType"));
        }
        return accessType6;
    }

    @Nullable
    public static Pair<String, PsiElement> getChildStringLiteralWithText(PsiElement element) {
        ASTNode literalNode = element.getNode().findChildByType(JSTokenTypes.STRING_LITERALS);
        if (literalNode == null) {
            return null;
        }
        String modulePath = literalNode.getText();
        PsiElement literalElement = literalNode.getPsi();
        return Pair.create((Object)modulePath, (Object)literalElement);
    }

    public static JSExpression getInitializer(ASTNode ownerNode) {
        ASTNode node = JSTreeUtil.getInitializerNode(ownerNode);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static <T extends PsiReference> T findReferenceOfClass(PsiReference ref, Class<T> clazz) {
        if (clazz.isInstance(ref)) {
            return (T)ref;
        }
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference : ((PsiMultiReference)ref).getReferences()) {
                if (!clazz.isInstance(reference)) continue;
                return (T)reference;
            }
        }
        return null;
    }

    @Nullable
    public static String getNameOrComputedPropertyName(@Nullable JSNamedElementBase element, boolean stubSafe) {
        String computedPropertyName;
        if (element == null) {
            return null;
        }
        String name = element.getName();
        if (name != null) {
            return name;
        }
        if (element instanceof JSComputedPropertyNameOwner && (computedPropertyName = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)element)) != null) {
            name = "[" + computedPropertyName + "]";
        }
        if (element instanceof JSDefinitionExpressionImpl && (!stubSafe || ((JSDefinitionExpressionImpl)element).getGreenStub() == null)) {
            PsiElement identifier = ((JSDefinitionExpression)element).getNameIdentifier();
            if (identifier != null) {
                String text = identifier.getText();
                name = "[" + text + "]";
            } else {
                JSExpression expression = ((JSDefinitionExpression)element).getExpression();
                if (expression instanceof JSIndexedPropertyAccessExpression) {
                    JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                    String text = indexExpression.getText();
                    name = "[" + text + "]";
                }
            }
        }
        return name;
    }

    @Nullable
    public static String getComputedPropertyNameWithoutBrackets(JSComputedPropertyNameOwner owner) {
        ES6ComputedName expr = owner.getComputedPropertyName();
        return expr == null ? null : expr.getExpressionAsPropertyName();
    }

    public static boolean isSymbolRef(JSExpression expr) {
        JSExpression qualifier;
        JSReferenceExpression ref;
        return expr instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression(ref = (JSReferenceExpression)expr) && (qualifier = ref.getQualifier()) instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, "Symbol");
    }

    @Nullable
    public static JSNamedElement findElementFromNameIdentifier(@NotNull PsiElement nameIdentifier) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findElementFromNameIdentifier"));
        }
        JSNamedElement candidate = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier, JSNamedElement.class);
        PsiElement identifier = candidate != null ? candidate.getNameIdentifier() : null;
        return identifier == nameIdentifier ? candidate : null;
    }

    public static boolean signatureIsExplicitlyDeclared(@NotNull JSFunctionItem function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "signatureIsExplicitlyDeclared"));
        }
        JSType returnType = function.getReturnType();
        if (returnType != null && returnType.getSource().isExplicitlyDeclared()) {
            return true;
        }
        if (function.isOverride()) {
            return true;
        }
        JSParameterItem[] parameters = function.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        for (JSParameterItem parameter : parameters) {
            JSType type = parameter.getType();
            if (type == null || !type.getSource().isExplicitlyDeclared()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSElement getScopeNode(@NotNull JSNamedElement node) {
        JSFunction constructorFunction;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getScopeNode"));
        }
        if (node instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)node) && (constructorFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null) {
            return JSPsiImplUtils.getScopeNode((JSNamedElement)constructorFunction);
        }
        return (JSElement)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSCatchBlock.class, JSClass.class, JSExecutionScope.class});
    }

    public static boolean isUseStrictStatement(@Nullable PsiElement currentChild) {
        JSExpression expression;
        if (currentChild instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)currentChild).getExpression()) instanceof JSLiteralExpression) {
            JSLiteralExpression literal = (JSLiteralExpression)expression;
            return "use strict".equals(literal.getValue());
        }
        return false;
    }

    public static boolean isCompilerDirectiveStatement(PsiElement element) {
        JSExpression expression;
        if (element instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)element).getExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isQuotedLiteral()) {
            Object value = ((JSLiteralExpression)expression).getValue();
            return "use strict".equals(value) || "use babel".equals(value);
        }
        return false;
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression) {
        JSDefinitionExpression definitionExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getInitializedElement"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSProperty || parent instanceof JSVariable) {
            return (JSQualifiedNamedElement)parent;
        }
        if (parent instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)parent).getDefinitionExpression()) != expression) {
            return definitionExpression;
        }
        return null;
    }

    @NotNull
    public static String getNameFromIdentifier(@NotNull ASTNode nameIdentifier) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getNameFromIdentifier"));
        }
        String string = StringUtil.replaceUnicodeEscapeSequences((String)StringUtil.unquoteString((String)nameIdentifier.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getNameFromIdentifier"));
        }
        return string;
    }

    public static boolean isClassMember(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "isClassMember"));
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            return true;
        }
        PsiElement context = element.getContext();
        if (context instanceof JSVarStatement) {
            context = context.getContext();
        }
        return context instanceof JSClass;
    }

    @Nullable
    public static PsiComment findTrailingEndOfLineComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findTrailingEndOfLineComment"));
        }
        PsiElement sibling = JSPsiImplUtils.getNextSiblingIgnoreWhitespace(element);
        if (sibling instanceof PsiComment && (sibling.getPrevSibling() == element || JSPsiImplUtils.hasInlineWhitespaceBefore(sibling))) {
            return (PsiComment)sibling;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement findLeadingCommentOrSelf(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.findLeadingComment(element), (Object)element);
    }

    @Nullable
    public static PsiComment findLeadingComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "findLeadingComment"));
        }
        PsiElement comment = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(element);
        if (comment instanceof PsiComment) {
            PsiElement afterComment = comment.getNextSibling();
            if (afterComment instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)afterComment.getText(), (char)'\n') <= 1 && !JSPsiImplUtils.hasInlineWhitespaceBefore(comment)) {
                return (PsiComment)comment;
            }
            return null;
        }
        return null;
    }

    public static boolean isGetterOrSetter(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "isGetterOrSetter"));
        }
        return function.isGetProperty() || function.isSetProperty();
    }

    private static boolean hasInlineWhitespaceBefore(@NotNull PsiElement comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "hasInlineWhitespaceBefore"));
        }
        PsiElement prevSibling = comment.getPrevSibling();
        if (prevSibling == null) {
            return false;
        }
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        return !prevSibling.textContains('\n');
    }

    public static boolean isForStatementDeclaration(@NotNull JSVariable jsVariable) {
        if (jsVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVariable", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "isForStatementDeclaration"));
        }
        PsiElement forOfCandidate = JSResolveUtil.findParent((PsiElement)jsVariable);
        return forOfCandidate instanceof JSForInStatement && jsVariable.getParent() == ((JSForInStatement)forOfCandidate).getDeclarationStatement();
    }

    public static boolean isIIFE(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "isIIFE"));
        }
        PsiElement node = JSPsiImplUtils.getTopmostParenthesizedOrSelf((PsiElement)function);
        PsiElement call = node.getParent();
        return call instanceof JSCallExpression && ((JSCallExpression)call).getMethodExpression() == node;
    }

    @NotNull
    private static PsiElement getTopmostParenthesizedOrSelf(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getTopmostParenthesizedOrSelf"));
        }
        PsiElement node = psiElement;
        PsiElement parent = node.getParent();
        while (parent instanceof JSParenthesizedExpression) {
            node = parent;
            parent = parent.getParent();
        }
        PsiElement psiElement2 = node;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils", "getTopmostParenthesizedOrSelf"));
        }
        return psiElement2;
    }

    @Nullable
    public static JSStatement findFirstFunctionStatement(@Nullable JSFunction function) {
        PsiElement anchor;
        if (function == null) {
            return null;
        }
        JSSourceElement body = function.getBody()[0];
        if (!(body instanceof JSBlockStatement)) {
            return null;
        }
        for (anchor = body.getFirstChild(); anchor != null && !(anchor instanceof JSStatement) || JSPsiImplUtils.isUseStrictStatement(anchor); anchor = anchor.getNextSibling()) {
        }
        return (JSStatement)anchor;
    }
}

