/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ES6QualifiedNameResolver
extends JSQualifiedNameResolver {
    @NotNull
    private final PsiElement myContext;

    public ES6QualifiedNameResolver(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "<init>"));
        }
        this.myContext = context;
    }

    @Override
    @NotNull
    protected JSQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "createNestedResolver"));
        }
        ES6QualifiedNameResolver eS6QualifiedNameResolver = new ES6QualifiedNameResolver(newContext);
        if (eS6QualifiedNameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "createNestedResolver"));
        }
        return eS6QualifiedNameResolver;
    }

    @Override
    @NotNull
    public Collection<PsiElement> resolveQualifiedName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveQualifiedName"));
        }
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(qName);
        List<String> components = name.toComponents();
        if (components.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveQualifiedName"));
            }
            return list;
        }
        String topLevelName = (String)ContainerUtil.getFirstItem(components);
        if (topLevelName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveQualifiedName"));
            }
            return list;
        }
        Collection<PsiElement> topLevelElements = this.resolveTopLevelElements(topLevelName);
        if (components.size() == 1) {
            Collection<PsiElement> collection = topLevelElements;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveQualifiedName"));
            }
            return collection;
        }
        Collection<PsiElement> lastElements = topLevelElements;
        List<String> localReferences = components.subList(1, components.size());
        for (int i = 0; i < localReferences.size(); ++i) {
            ProgressIndicatorProvider.checkCanceled();
            String currentName = localReferences.get(i);
            boolean isQualifier = localReferences.size() != i + 1;
            lastElements = this.resolveLocalElements(currentName, lastElements, isQualifier);
            if (!lastElements.isEmpty()) continue;
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveQualifiedName"));
            }
            return list;
        }
        Collection<PsiElement> collection = lastElements;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveQualifiedName"));
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveTopLevelElements(@NotNull String topLevelName) {
        if (topLevelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelName", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveTopLevelElements"));
        }
        Collection<PsiElement> rawTopLevelElements = this.resolveTopLevelName(topLevelName);
        Collection<PsiElement> collection = this.expandElements(rawTopLevelElements);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveTopLevelElements"));
        }
        return collection;
    }

    @NotNull
    private Collection<PsiElement> resolveLocalElements(@NotNull String name, @NotNull Collection<PsiElement> scopes, boolean isQualifier) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveLocalElements"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveLocalElements"));
        }
        HashSet collectedElements = ContainerUtil.newHashSet();
        for (PsiElement scopeElement : scopes) {
            collectedElements.addAll(this.getLocalElements(name, scopeElement, this.myContext, isQualifier));
        }
        Collection<PsiElement> collection = scopes = this.expandElements(collectedElements);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveLocalElements"));
        }
        return collection;
    }

    private Collection<PsiElement> expandElements(@NotNull Collection<PsiElement> rawTopLevelElements) {
        if (rawTopLevelElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawTopLevelElements", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "expandElements"));
        }
        return rawTopLevelElements.stream().map(this::expandElement).flatMap(el -> el.stream()).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<PsiElement> resolveTopLevelName(@NotNull String globalOrScopedName) {
        if (globalOrScopedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalOrScopedName", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveTopLevelName"));
        }
        PsiElement moduleScope = ES6PsiUtil.getNonStrictExportScope(this.myContext);
        List<PsiElement> list = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(globalOrScopedName, moduleScope == null ? this.myContext : moduleScope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "resolveTopLevelName"));
        }
        return list;
    }

    @NotNull
    public static TypeScriptModuleDeclarationsProcessor createProcessor(@NotNull String name, boolean strictType, boolean allowExport) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "createProcessor"));
        }
        TypeScriptModuleDeclarationsProcessor typeScriptModuleDeclarationsProcessor = new TypeScriptModuleDeclarationsProcessor(name, strictType, allowExport);
        if (typeScriptModuleDeclarationsProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver", "createProcessor"));
        }
        return typeScriptModuleDeclarationsProcessor;
    }
}

