/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUtils {
    private static final TokenSet ATTRIBUTE_LIST_STOP_AT = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE})});

    @Nullable
    public static JSLanguageDialect getDialect(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        Language language = file.getLanguage();
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : DialectDetector.getLanguageDialect((PsiElement)file);
    }

    public static boolean isJavaScriptFile(VirtualFile file) {
        return file != null && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isJavaScriptFile(PsiFile file) {
        return file != null && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isNeedParenthesis(JSExpression oldExpr, JSExpression newExpr) {
        int priority = JSUtils.getExpressionPrecedence(newExpr);
        PsiElement parent = oldExpr.getParent();
        if (!(parent instanceof JSExpression) || parent instanceof JSFunctionExpression) {
            return false;
        }
        int parentPriority = JSUtils.getExpressionPrecedence((JSExpression)parent);
        if (priority < parentPriority) {
            return true;
        }
        if (priority == parentPriority && parent instanceof JSCallExpression && newExpr instanceof JSFunctionExpression) {
            return true;
        }
        if (priority == parentPriority && parent instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            if (oldExpr != ((JSBinaryExpression)parent).getROperand()) {
                return false;
            }
            if (!JSTokenTypes.ASSOC_OPERATIONS.contains(operationSign)) {
                return true;
            }
            return ((JSBinaryExpression)newExpr).getOperationSign() != operationSign;
        }
        return false;
    }

    private static int getExpressionPrecedence(JSExpression expr) {
        IElementType i = expr.getNode().getElementType();
        if (i == JSElementTypes.ASSIGNMENT_EXPRESSION) {
            return 0;
        }
        if (i == JSElementTypes.CONDITIONAL_EXPRESSION) {
            return 1;
        }
        if (i == JSElementTypes.BINARY_EXPRESSION) {
            IElementType opType = ((JSBinaryExpression)expr).getOperationSign();
            if (opType == JSTokenTypes.OROR) {
                return 2;
            }
            if (opType == JSTokenTypes.ANDAND) {
                return 3;
            }
            if (opType == JSTokenTypes.OR) {
                return 4;
            }
            if (opType == JSTokenTypes.XOR) {
                return 5;
            }
            if (opType == JSTokenTypes.AND) {
                return 6;
            }
            if (JSTokenTypes.EQUALITY_OPERATIONS.contains(opType)) {
                return 7;
            }
            if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(opType)) {
                return 8;
            }
            if (JSTokenTypes.SHIFT_OPERATIONS.contains(opType)) {
                return 9;
            }
            if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(opType)) {
                return 10;
            }
            if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(opType)) {
                return 11;
            }
            return 8;
        }
        if (i == JSElementTypes.PREFIX_EXPRESSION) {
            return 12;
        }
        if (i == JSElementTypes.POSTFIX_EXPRESSION) {
            return 13;
        }
        return 14;
    }

    @Nullable
    public static PsiElement findFunctionAnchor(@Nullable PsiElement scope, @Nullable PsiElement functionAnchor, boolean shouldPlaceAtScopeStart) {
        PsiElement grandParent;
        PsiComment docComment;
        if (scope == null || functionAnchor == null) {
            return null;
        }
        while (functionAnchor != null && functionAnchor.getParent() != scope) {
            functionAnchor = functionAnchor.getParent();
        }
        if (functionAnchor instanceof JSProperty && (docComment = JSDocumentationUtils.findDocComment(functionAnchor)) != null) {
            functionAnchor = docComment;
        }
        if ((grandParent = scope.getParent()) instanceof JSFunction && shouldPlaceAtScopeStart) {
            JSStatement statement = JSPsiImplUtils.findFirstFunctionStatement((JSFunction)grandParent);
            while (statement instanceof JSVarStatement && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)grandParent, (boolean)true) || statement instanceof PsiWhiteSpace || statement instanceof PsiComment) {
                statement = statement.getNextSibling();
            }
            if (statement != null) {
                return statement;
            }
        }
        return functionAnchor;
    }

    @Nullable
    public static PsiElement findStatementAnchor(PsiElement referenceExpression, PsiFile file) {
        return JSUtils.findStatementAnchor(referenceExpression, file, false);
    }

    @Nullable
    public static PsiElement findStatementAnchor(PsiElement referenceExpression, PsiFile file, boolean withSource) {
        JSEmbeddedContent scriptTagAnchor;
        PsiElement anchor;
        Object object = anchor = withSource ? JSUtils.findSourceAnchor(referenceExpression, DialectDetector.isActionScript(referenceExpression)) : PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSStatement.class);
        if (anchor != null) {
            if (anchor instanceof JSPackageStatement) {
                return null;
            }
            PsiElement anchorParent = anchor.getParent();
            if (anchorParent instanceof JSIfStatement || anchorParent instanceof JSTryStatement) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)anchor, JSStatement.class);
            }
        }
        if (file instanceof XmlFile && PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, XmlAttributeValue.class) != null && (scriptTagAnchor = JSUtils.findScriptTagContent((XmlFile)file)) != null) {
            return scriptTagAnchor;
        }
        return anchor;
    }

    @Nullable
    public static JSEmbeddedContent findScriptTagContent(@NotNull XmlFile file) {
        XmlTag scriptTag;
        XmlTag headTag;
        XmlTag tag;
        TemplateLanguageFileViewProvider viewProvider;
        PsiFile psi;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/util/JSUtils", "findScriptTagContent"));
        }
        XmlFile root = file;
        if (root.getViewProvider() instanceof TemplateLanguageFileViewProvider && (psi = (viewProvider = (TemplateLanguageFileViewProvider)root.getViewProvider()).getPsi(viewProvider.getTemplateDataLanguage())) instanceof XmlFile) {
            root = (XmlFile)psi;
        }
        if ((tag = root.getDocument().getRootTag()) != null && (headTag = tag.findFirstSubTag("head")) != null && (scriptTag = headTag.findFirstSubTag("script")) != null) {
            return (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)scriptTag, JSEmbeddedContent.class);
        }
        return null;
    }

    @Nullable
    public static JSSourceElement findSourceAnchor(PsiElement expression, boolean acceptMembers) {
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)expression, JSSourceElement.class, (boolean)true);
        if (anchor == null || anchor instanceof JSStatement && (acceptMembers || !JSUtils.isMember(anchor))) {
            return (JSSourceElement)anchor;
        }
        if (!(anchor instanceof JSExpression || !acceptMembers && JSUtils.isMember(anchor))) {
            return (JSSourceElement)anchor;
        }
        return JSUtils.findSourceAnchor(anchor, acceptMembers);
    }

    @NotNull
    public static JSAttributeList.AccessType getImplicitAccessType(@NotNull PsiElement element) {
        boolean typeScript;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
        }
        PsiElement parent = element.getContext();
        if (parent == null) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
            }
            return accessType;
        }
        if (parent instanceof JSClass && ((JSClass)parent).isInterface()) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
            }
            return accessType;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        boolean bl = typeScript = dialect != null && dialect.isTypeScript;
        if (typeScript) {
            JSAttributeListOwner firstAttributeListParent;
            PsiFile file = parent.getContainingFile();
            if (file != null && DialectDetector.isTypeScriptDefinitionFile(file) && !(element instanceof TypeScriptImportStatement)) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
                }
                return accessType;
            }
            if (element instanceof TypeScriptModule && element.getParent() instanceof JSFile && file instanceof JSFile && !((JSFile)file).isCommonJSModule()) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
                }
                return accessType;
            }
            JSAttributeListOwner attrListOwner = firstAttributeListParent = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)parent, JSAttributeListOwner.class, (boolean)false);
            if (!(element instanceof TypeScriptImportStatement)) {
                while (attrListOwner != null) {
                    JSAttributeList attributeList = attrListOwner.getAttributeList();
                    if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE)) {
                        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                        if (accessType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
                        }
                        return accessType;
                    }
                    attrListOwner = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)attrListOwner, (Class[])new Class[]{JSAttributeListOwner.class});
                }
            }
            if (firstAttributeListParent instanceof TypeScriptModule) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
                if (accessType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
                }
                return accessType;
            }
        }
        if (parent instanceof TypeScriptModule) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
            }
            return accessType;
        }
        if (typeScript && !(parent instanceof JSFile)) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = dialect != null && dialect.isECMA4 ? JSAttributeList.AccessType.PACKAGE_LOCAL : JSAttributeList.AccessType.PUBLIC;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getImplicitAccessType"));
        }
        return accessType;
    }

    public static boolean packageExists(String packageName, GlobalSearchScope scope) {
        if (StringUtil.isEmpty((String)packageName)) {
            return true;
        }
        return !FileBasedIndex.getInstance().getValues(JSPackageIndex.INDEX_ID, (Object)packageName, scope).isEmpty();
    }

    public static boolean isValidClassName(String name, boolean acceptFqn) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (acceptFqn) {
            return name.trim().matches("[\\p{Alpha}][\\p{Alnum}_]*(\\.[\\p{Alpha}][\\p{Alnum}_]*)*");
        }
        return name.trim().matches("[\\p{Alpha}][\\p{Alnum}_]*");
    }

    public static boolean isMember(PsiElement element) {
        return JSUtils.getMemberContainingClass(element) != null;
    }

    @Contract(value="null->null")
    public static JSClass getMemberContainingClass(@Nullable PsiElement methodOrField) {
        PsiElement clazz = null;
        if (methodOrField instanceof JSFunction) {
            clazz = methodOrField.getParent();
            if (clazz instanceof JSExpressionCodeFragment) {
                clazz = clazz.getContext();
            }
        } else if (methodOrField instanceof JSParameter) {
            JSFunction function;
            JSParameter parameter = (JSParameter)methodOrField;
            if (TypeScriptPsiUtil.isFieldParameter(parameter) && (function = parameter.getDeclaringFunction()) instanceof TypeScriptFunction && function.isConstructor()) {
                clazz = function.getParent();
            }
        } else if (methodOrField instanceof JSVariable) {
            clazz = methodOrField.getParent().getParent();
        } else if (methodOrField instanceof JSVarStatement) {
            clazz = methodOrField.getParent();
        } else if (methodOrField instanceof JSField) {
            clazz = methodOrField.getParent();
        }
        if (clazz instanceof JSFile) {
            clazz = JSResolveUtil.getXmlBackedClass((JSFile)clazz);
        }
        if (clazz instanceof TypeScriptObjectType) {
            clazz = clazz.getParent();
        }
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @Nullable
    public static JSReferenceExpression getMethodNameIfInsideCall(PsiElement parent) {
        JSExpression invokedMethod;
        PsiElement grandParent;
        if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (invokedMethod = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            return (JSReferenceExpression)invokedMethod;
        }
        return null;
    }

    @Nullable
    public static JSCallExpression findCallExprByArg(@Nullable PsiElement arg) {
        PsiElement argList;
        PsiElement psiElement = argList = arg == null ? null : arg.getParent();
        if (argList instanceof JSArgumentList) {
            return (JSCallExpression)ObjectUtils.tryCast((Object)argList.getParent(), JSCallExpression.class);
        }
        return null;
    }

    public static int findParameterIndex(JSFunction function, JSParameter parameter) {
        JSParameter[] parameters = function.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            return i;
        }
        return -1;
    }

    public static JSReferenceExpression findRefExprThatStartCallChaining(JSReferenceExpression qualifier) {
        JSExpression methodExpression;
        JSExpression expression;
        JSReferenceExpression localQualifier = qualifier;
        while ((expression = localQualifier.getQualifier()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSReferenceExpression) {
            localQualifier = (JSReferenceExpression)methodExpression;
        }
        return localQualifier;
    }

    @Nullable
    @Contract(value="!null->!null")
    public static JSExpression unparenthesize(@Nullable JSExpression expression) {
        while (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        return expression;
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSUtils", "getParentSkipParentheses"));
        }
        return PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{JSParenthesizedExpression.class});
    }

    public static JSExpression[] findExpressionOccurrences(JSElement scope, Pair<JSExpression, TextRange> expr, boolean visitInnerFunctions) {
        if (expr.second != null) {
            return new JSExpression[]{(JSExpression)expr.first};
        }
        ArrayList<JSExpression> array = new ArrayList<JSExpression>();
        JSUtils.addExpressionOccurrences(JSUtils.unparenthesize((JSExpression)expr.first), array, (PsiElement)scope, visitInnerFunctions);
        return array.toArray(new JSExpression[array.size()]);
    }

    private static void addExpressionOccurrences(JSExpression expr, List<JSExpression> array, PsiElement scope, boolean visitInnerFunctions) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            if (child instanceof JSExpression) {
                child = JSUtils.unparenthesize((JSExpression)child);
            }
            if (child == null) continue;
            if (child instanceof JSExpression) {
                boolean add = PsiEquivalenceUtil.areElementsEquivalent((PsiElement)child, (PsiElement)expr, null, (element1, element2) -> {
                    assert (element1 != null);
                    assert (element2 != null);
                    if (element1.textMatches(element2)) {
                        return 0;
                    }
                    if (element1.getNode().getElementType() == JSTokenTypes.STRING_LITERAL && element2.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
                        String text1 = element1.getText();
                        String text2 = element2.getText();
                        if (StringUtil.equals((CharSequence)StringUtil.unquoteString((String)text1), (CharSequence)StringUtil.unquoteString((String)text2))) {
                            return 0;
                        }
                    }
                    return 1;
                });
                if (add && child != expr) {
                    add = !JSResolveUtil.isSelfReference(scope, child);
                    add &= JSReadWriteAccessDetector.ourInstance.getExpressionAccess(child) == ReadWriteAccessDetector.Access.Read || JSResolveUtil.isSelfReference((PsiElement)expr);
                }
                if ((add &= !(scope instanceof JSPrefixExpression) || ((JSPrefixExpression)scope).getOperationSign() != JSTokenTypes.DELETE_KEYWORD) && child instanceof JSParenthesizedExpression && (scope instanceof JSPrefixExpression && (((JSPrefixExpression)scope).getOperationSign() == JSTokenTypes.DELETE_KEYWORD || ((JSPrefixExpression)scope).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) || scope instanceof JSNewExpression || scope instanceof JSCaseClause || scope instanceof JSReturnStatement || scope instanceof JSBinaryExpression && ((JSBinaryExpression)scope).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD)) {
                    add = false;
                }
                if (add) {
                    array.add((JSExpression)child);
                    continue;
                }
            }
            if (!visitInnerFunctions && child instanceof JSFunction && JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)child) == null) continue;
            JSUtils.addExpressionOccurrences(expr, array, child, visitInnerFunctions);
        }
    }

    @NotNull
    public static String getConfigJavaScriptDirPath() {
        String string = PathManager.getConfigPath() + File.separatorChar + "javascript";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSUtils", "getConfigJavaScriptDirPath"));
        }
        return string;
    }

    public static boolean isScopeOwner(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSUtils", "isScopeOwner"));
        }
        return element instanceof JSFunction || element instanceof JSClass || element instanceof TypeScriptModule || element instanceof JSPackageStatement || element instanceof JSPackage;
    }

    @Nullable
    public static PsiElement getChildExcludingTypes(@NotNull PsiElement element, Class<?> ... classes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSUtils", "getChildExcludingTypes"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/lang/javascript/psi/util/JSUtils", "getChildExcludingTypes"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            boolean filtered = false;
            for (Class<?> aClass : classes) {
                if (!aClass.isInstance(child)) continue;
                filtered = true;
                break;
            }
            if (filtered) continue;
            return child;
        }
        return null;
    }

    public static boolean isLineBreakWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)element.getText());
    }

    @Nullable
    public static JSAttributeList getAttributeList(@NotNull StubBasedPsiElementBase<?> elementBase) {
        if (elementBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementBase", "com/intellij/lang/javascript/psi/util/JSUtils", "getAttributeList"));
        }
        return (JSAttributeList)JSStubBasedPsiTreeUtil.getStubOrPsiChild(elementBase, JSStubElementTypes.ATTRIBUTE_LISTS, ATTRIBUTE_LIST_STOP_AT);
    }

    public static boolean isStatementUsuallyRequiringSemicolon(@NotNull JSStatement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/util/JSUtils", "isStatementUsuallyRequiringSemicolon"));
        }
        return node instanceof JSVarStatement || node instanceof JSExpressionStatement || node instanceof JSBreakStatement || node instanceof JSContinueStatement || node instanceof JSReturnStatement || node instanceof JSThrowStatement || node instanceof JSDoWhileStatement || node instanceof JSEmptyStatement;
    }

    public static boolean isLocallyDefined(@Nullable JSNamedElement node, @Nullable PsiElement scopeNode) {
        if (scopeNode == null || node == null) {
            return false;
        }
        if (!(node instanceof JSAttributeListOwner)) {
            return false;
        }
        if (node.getParent() instanceof JSExportAssignment || JSUtils.isExportedAsPartOFParentExport((PsiElement)node)) {
            return false;
        }
        if (!(scopeNode instanceof JSClass || scopeNode instanceof JSFile || scopeNode instanceof TypeScriptModule)) {
            return true;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)node).getAttributeList();
        if (scopeNode instanceof JSFile && ((JSFile)scopeNode).isCommonJSModule() && (attributeList == null || attributeList.getExplicitAccessType() != JSAttributeList.AccessType.PUBLIC)) {
            return true;
        }
        if (attributeList == null) {
            return false;
        }
        if (DialectDetector.isTypeScript((PsiElement)node) && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)node)) {
            return false;
        }
        PsiElement nodeParent = node.getParent();
        return attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || DialectDetector.isActionScript(scopeNode) && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL && nodeParent instanceof JSFile && nodeParent.getContext() == null;
    }

    private static boolean isExportedAsPartOFParentExport(@NotNull PsiElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/util/JSUtils", "isExportedAsPartOFParentExport"));
        }
        for (PsiElement current = node; current != null && !(current instanceof JSFile) && !(current instanceof JSEmbeddedContent); current = current.getParent()) {
            JSAttributeList.AccessType type;
            if (current instanceof JSAttributeListOwner && ((JSAttributeListOwner)current).getAttributeList() != null && JSAttributeList.AccessType.PRIVATE.equals((Object)(type = ((JSAttributeListOwner)current).getAttributeList().getAccessType()))) {
                return false;
            }
            if (JSUtils.isDirectlyExported(current)) {
                return true;
            }
            if ((!node.equals(current) || !(current instanceof JSProperty)) && !(current instanceof JSObjectLiteralExpression) && (!(current instanceof JSProperty) || current instanceof JSFunctionProperty)) break;
        }
        return false;
    }

    private static boolean isDirectlyExported(@Nullable PsiElement current) {
        return current instanceof JSElementBase && (((JSElementBase)current).isExportedWithDefault() || ((JSElementBase)current).isExported()) || JSUtils.isExportStatementSyntaxElement(current);
    }

    private static boolean isExportStatementSyntaxElement(@Nullable PsiElement current) {
        return current instanceof ES6ExportDefaultAssignment || current instanceof ES6ExportDeclaration || current instanceof ES6ExportedDefaultBinding;
    }
}

