/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class RecursionVisitor
extends JSRecursiveWalkingElementVisitor {
    private boolean recursive;
    private final JSFunction function;
    private final String functionName;
    private final boolean accessMethod;

    public RecursionVisitor(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/RecursionVisitor", "<init>"));
        }
        this.recursive = false;
        this.function = function;
        this.functionName = function.getName();
        this.accessMethod = JSPsiImplUtils.isGetterOrSetter(function);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/RecursionVisitor", "visitElement"));
        }
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    public void visitJSCallExpression(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/psi/util/RecursionVisitor", "visitJSCallExpression"));
        }
        if (this.recursive) {
            return;
        }
        super.visitJSCallExpression(call);
        JSExpression methodExpression = call.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return;
        }
        this.processRefExpr((JSReferenceExpression)methodExpression);
    }

    private void processRefExpr(JSReferenceExpression functionExpression) {
        String calledFunctionName = functionExpression.getReferencedName();
        if (calledFunctionName == null) {
            return;
        }
        if (!calledFunctionName.equals(this.functionName)) {
            return;
        }
        PsiElement referent = functionExpression.resolve();
        if (!this.function.equals(referent)) {
            return;
        }
        JSExpression qualifier = functionExpression.getQualifier();
        if (qualifier == null || qualifier instanceof JSThisExpression) {
            this.recursive = true;
        }
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (this.recursive || !this.accessMethod) {
            return;
        }
        PsiElement parent = node.getParent();
        if (parent instanceof JSCallExpression || parent instanceof JSReferenceExpression) {
            return;
        }
        super.visitJSReferenceExpression(node);
        this.processRefExpr(node);
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

