/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceAnnotationProvider;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceFilter;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingStateHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceHighlightingPass
extends TextEditorHighlightingPass {
    private static final JSLanguageServiceAnnotationProvider ANNOTATOR = new JSLanguageServiceAnnotationProvider();
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final JSLanguageServiceHighlightingStateHolder myHolder;
    private final JSLanguageService myLanguageService;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final AnnotationHolderImpl myAnnotationHolder;
    private volatile List<JSAnnotationError> myLastResult;

    public JSLanguageServiceHighlightingPass(@NotNull Project project, @NotNull JSLanguageService languageService, @NotNull PsiFile file, @NotNull JSLanguageServiceHighlightingStateHolder myStateHolder, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "<init>"));
        }
        if (languageService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageService", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "<init>"));
        }
        if (myStateHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myStateHolder", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "<init>"));
        }
        super(project, editor.getDocument(), false);
        this.myLastResult = null;
        this.myFile = file;
        this.myHolder = myStateHolder;
        this.myLanguageService = languageService;
        this.myEditor = editor;
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file));
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "doCollectInformation"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.needProcessHighlight()) {
            this.myLastResult = ContainerUtil.emptyList();
            return;
        }
        long docTimeStamp = this.myEditor.getDocument().getModificationStamp();
        JSLanguageServiceHighlightingStateHolder.CalcState runningState = this.myHolder.getState(this.myFile);
        if (runningState != null) {
            Future<List<JSAnnotationError>> future = runningState.future;
            if (future.isDone()) {
                this.myLastResult = JSLanguageServiceHighlightingPass.awaitResults(future, progress);
                this.myHolder.reset(this.myFile);
                if (docTimeStamp == runningState.stamp) {
                    return;
                }
            } else {
                if (docTimeStamp == runningState.stamp) {
                    this.myLastResult = JSLanguageServiceHighlightingPass.awaitResults(future, progress);
                    this.myHolder.reset(this.myFile);
                    return;
                }
                this.myHolder.reset(this.myFile);
                future.cancel(false);
            }
        }
        this.startAwaitingNewResults(progress, docTimeStamp);
    }

    private void startAwaitingNewResults(@NotNull ProgressIndicator progress, long docTimeStamp) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "startAwaitingNewResults"));
        }
        JSFileHighlightingInfo info = JSHighlightingInfoBuilder.createInfoWithUnSavedFiles(this.myProject, this.myFile.getVirtualFile(), this.myLanguageService.getAcceptableFilesFilter());
        Future<List<JSAnnotationError>> future = this.myLanguageService.highlight(this.myFile, info);
        if (future == null) {
            return;
        }
        this.myHolder.saveState(this.myFile, new JSLanguageServiceHighlightingStateHolder.CalcState(future, docTimeStamp));
        this.myLastResult = JSLanguageServiceHighlightingPass.awaitResults(future, progress);
        this.myHolder.reset(this.myFile);
    }

    @Nullable
    private static List<JSAnnotationError> awaitResults(@Nullable Future<List<JSAnnotationError>> future, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "awaitResults"));
        }
        return JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.TIMEOUT_MILLS, 10L, progress);
    }

    public void doApplyInformationToEditor() {
        if (this.myDocument == null) {
            return;
        }
        boolean needApply = this.needProcessHighlight();
        if (needApply) {
            ANNOTATOR.apply(this.myFile, this.myLastResult, (AnnotationHolder)this.myAnnotationHolder, this.myLanguageService);
        }
        List<HighlightInfo> infos = this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private boolean needProcessHighlight() {
        return JSLanguageServiceFilter.checkAvailable(this.myProject, this.myLanguageService, this.myFile.getVirtualFile()) && this.myLanguageService.canHighlight(this.myFile);
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = this.getHighlights();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "getInfos"));
        }
        return list;
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        if (this.myAnnotationHolder.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "getHighlights"));
            }
            return list;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        for (Annotation annotation : this.myAnnotationHolder) {
            infos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass", "getHighlights"));
        }
        return arrayList;
    }
}

