/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceActionPanelBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceErrorTreeViewPanel
extends NewErrorTreeViewPanel {
    public JSLanguageServiceErrorTreeViewPanel(Project project, @NotNull String helpId, @Nullable Runnable cleanAction, @Nullable AnAction[] leftPanelActions, @Nullable AnAction[] rightPanelActions) {
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceErrorTreeViewPanel", "<init>"));
        }
        super(project, helpId, false, false);
        TreeExpander treeExpander = (TreeExpander)this.getData(PlatformDataKeys.TREE_EXPANDER.getName());
        if (treeExpander != null) {
            CommonActionsManager instance = CommonActionsManager.getInstance();
            Object[] treeActions = new AnAction[]{instance.createExpandAllAction(treeExpander, (JComponent)((Object)this)), instance.createCollapseAllAction(treeExpander, (JComponent)((Object)this))};
            rightPanelActions = rightPanelActions == null ? treeActions : (AnAction[])ArrayUtil.mergeArrays((Object[])rightPanelActions, (Object[])treeActions);
        }
        Runnable cleanRunnable = () -> {
            if (cleanAction != null) {
                cleanAction.run();
            }
            this.getErrorViewStructure().clear();
            this.updateTree();
        };
        JPanel panel = JSLanguageServiceActionPanelBuilder.createToolPanel(helpId, () -> ((JSLanguageServiceErrorTreeViewPanel)this).close(), cleanRunnable, rightPanelActions, leftPanelActions);
        this.add(panel, "West");
        this.myTree.getEmptyText().setText(JSLanguageServiceErrorTreeViewPanel.getDefaultNoErrorsText());
    }

    @NotNull
    public static String getDefaultNoErrorsText() {
        String string = JSBundle.message((String)"javascript.language.service.default.empty.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceErrorTreeViewPanel", "getDefaultNoErrorsText"));
        }
        return string;
    }
}

