/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionCollector {
    private final Map<String, Object> functions = new LinkedHashMap<String, Object>();

    @NotNull
    public static JSFunctionCollector collectAllVisibleClassFunctions(@NotNull JSClass jsClass, @Nullable JSFunctionCollector _functions, final @Nullable Predicate<JSFunction> filter) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/JSFunctionCollector", "collectAllVisibleClassFunctions"));
        }
        final JSFunctionCollector functions = _functions != null ? _functions : new JSFunctionCollector();
        jsClass.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
            {
                super(name);
                this.setToProcessHierarchy(true);
                this.setLocalResolve(true);
                this.setSkipImplicitDeclarations(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/JSFunctionCollector$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/validation/JSFunctionCollector$1", "execute"));
                }
                if (element instanceof JSFunction) {
                    JSFunction function = (JSFunction)element;
                    if (function.isConstructor()) {
                        return true;
                    }
                    if (filter != null && !filter.test(function)) {
                        return true;
                    }
                    if (function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadDeclaration()) {
                        return true;
                    }
                    functions.add(function);
                }
                return true;
            }
        }, ResolveState.initial(), (PsiElement)jsClass, (PsiElement)jsClass);
        JSFunctionCollector jSFunctionCollector = functions;
        if (jSFunctionCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSFunctionCollector", "collectAllVisibleClassFunctions"));
        }
        return jSFunctionCollector;
    }

    @Nullable
    public JSFunction findFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        Object candidate = this.functions.get(name);
        if (candidate instanceof JSFunction) {
            return ((JSFunction)candidate).getKind() == kind ? (JSFunction)candidate : null;
        }
        if (candidate instanceof JSFunction[]) {
            JSFunction[] jsFunctions;
            for (JSFunction fun : jsFunctions = (JSFunction[])candidate) {
                if (fun.getKind() != kind) continue;
                return fun;
            }
        }
        return null;
    }

    public void add(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSFunctionCollector", "add"));
        }
        String s = function.getName();
        Object functionValue = this.functions.get(s);
        if (functionValue == null) {
            this.functions.put(s, function);
        } else if (functionValue instanceof JSFunction) {
            JSFunction oldFunction = (JSFunction)functionValue;
            if (this.findFunctionWithTheSameKind(s, function.getKind()) == null) {
                this.functions.put(s, new JSFunction[]{oldFunction, function});
            }
        }
    }

    public void removeFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        Object o = this.functions.get(name);
        if (o instanceof JSFunction && ((JSFunction)o).getKind() == kind) {
            this.functions.remove(name);
        } else if (o instanceof JSFunction[]) {
            JSFunction[] functions = (JSFunction[])o;
            this.functions.put(name, functions[0].getKind() == kind ? functions[1] : functions[0]);
        }
    }

    @NotNull
    public Collection<JSFunction> getFunctions() {
        ArrayList<JSFunction> result = new ArrayList<JSFunction>();
        for (Map.Entry<String, Object> entry : this.functions.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof JSFunction[]) {
                ContainerUtil.addAll(result, (Object[])((JSFunction[])value));
                continue;
            }
            result.add((JSFunction)value);
        }
        ArrayList<JSFunction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSFunctionCollector", "getFunctions"));
        }
        return arrayList;
    }

    public boolean hasFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        return this.findFunctionWithTheSameKind(name, kind) != null;
    }
}

