/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ChangeTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myType;
    private final String myNameKey;
    private final String myElementName;

    public ChangeTypeFix(JSNamedElement namedElement, String typeQName, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String nameKey) {
        super((PsiElement)namedElement);
        this.myType = typeQName;
        this.myNameKey = nameKey;
        this.myElementName = namedElement.getName();
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)this.myNameKey, (Object[])new Object[]{this.myElementName, this.myType});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeTypeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/ChangeTypeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/ChangeTypeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/ChangeTypeFix", "invoke"));
        }
        JSRefactoringUtil.setType((JSNamedElement)startElement, this.myType, true);
    }
}

