/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGoToDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceElement == null) {
            return null;
        }
        Project project = editor.getProject();
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (project == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(editor.getProject())) {
                return null;
            }
            VirtualFile virtualFile = sourceElement.getContainingFile().getVirtualFile();
            TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(project, virtualFile);
            if (service == null || !service.checkCanUseService()) {
                return null;
            }
            ResolveResult[] results = ((JSReferenceExpression)parent).multiResolve(false);
            if (results.length == 0) {
                return TypeScriptGoToDeclarationHandler.getResultsFromTypeScriptService(project, editor, sourceElement);
            }
        } else if (parent instanceof JSVariable && TypeScriptGoToDeclarationHandler.useVariableAsDeclaration((JSVariable)parent, sourceElement) || parent instanceof TypeScriptFunction && TypeScriptGoToDeclarationHandler.useFunctionAsDeclaration((TypeScriptFunction)parent, sourceElement)) {
            return new PsiElement[]{parent};
        }
        return null;
    }

    @Nullable
    private static PsiElement[] getResultsFromTypeScriptService(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement sourceElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getResultsFromTypeScriptService"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getResultsFromTypeScriptService"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getResultsFromTypeScriptService"));
        }
        Future<TypeScriptResponseCommon.FileSpan[]> future = TypeScriptLanguageServiceEvents.getService(project).getDeclaration(sourceElement, editor.getDocument());
        if (future == null) {
            return null;
        }
        TypeScriptResponseCommon.FileSpan[] spans = JSLanguageServiceUtil.awaitFuture(future, 700L, 10L, null);
        if (spans == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (PsiElement[])Arrays.stream(spans).map(el -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "lambda$getResultsFromTypeScriptService$0"));
            }
            String path = el.file;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null) {
                return null;
            }
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null) {
                return null;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return null;
            }
            return TypeScriptGoToDeclarationHandler.getElement(psiFile, document, el);
        }).filter(el -> el != null).map(el -> JSTargetElementEvaluator.adjustTargetElement(el)).toArray(PsiElement[]::new);
    }

    private static boolean useVariableAsDeclaration(@NotNull JSVariable variable, @NotNull PsiElement sourceElement) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "useVariableAsDeclaration"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "useVariableAsDeclaration"));
        }
        return TypeScriptGoToDeclarationHandler.isIdentifier(sourceElement, variable.getNameIdentifier()) && (variable.hasInitializer() || variable instanceof JSParameter && variable.getReferences().length == 0) && variable.getTypeElement() == null && !JSDestructuringUtil.isDestructuring(variable.getParent());
    }

    private static boolean useFunctionAsDeclaration(@NotNull TypeScriptFunction function, @NotNull PsiElement sourceElement) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "useFunctionAsDeclaration"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "useFunctionAsDeclaration"));
        }
        return TypeScriptGoToDeclarationHandler.isIdentifier(sourceElement, function.getNameIdentifier()) && function.getReturnTypeElement() == null && function.getBody().length > 0;
    }

    private static boolean isIdentifier(@NotNull PsiElement sourceElement, @Nullable PsiElement name) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "isIdentifier"));
        }
        return sourceElement.isEquivalentTo(name);
    }

    @Nullable
    private static PsiElement getElement(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull TypeScriptResponseCommon.FileSpan span) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getElement"));
        }
        if (span == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "span", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getElement"));
        }
        TypeScriptResponseCommon.Location start = span.start;
        TypeScriptResponseCommon.Location end = span.end;
        JSLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getPsiElementInfo(psiFile, document, start, end);
        if (info == null) {
            return null;
        }
        PsiElement element = info.getElement();
        if (element != null) {
            return element;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        return TypeScriptGoToDeclarationHandler.getPsiElementByRange(psiFile, range);
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getPsiElementByRange"));
        }
        int rangeStartOffset = range.getStartOffset();
        PsiElement startElement = psiFile.findElementAt(rangeStartOffset);
        if (startElement == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }
}

