/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCurrentAction
extends TypeScriptCompileAllAction {
    public TypeScriptCompileCurrentAction() {
        super(JSBundle.message((String)"typescript.compiler.action.compile.current", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.current.description", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1);
    }

    @Nullable
    private static VirtualFile getCurrentFile(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            return psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return null;
    }

    @Override
    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileCurrentAction", "canUseOnlyConfigs"));
        }
        return false;
    }

    @Override
    @Nullable
    protected Consumer<ProgressIndicator> getBackgroundProcess(@Nullable Project project, @Nullable DataContext context) {
        if (project == null) {
            return null;
        }
        VirtualFile configFile = TypeScriptCompileCurrentAction.getTypeScriptConfigVirtualFile(context);
        if (configFile != null) {
            return indicator -> {
                TypeScriptConfig config2 = (TypeScriptConfig)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> TypeScriptConfigService.Provider.getConfig(project, configFile));
                if (config2 == null) {
                    return;
                }
                TypeScriptCompilerService compilerService = this.getServiceForConfig(project, configFile);
                if (compilerService == null) {
                    return;
                }
                LinkedHashSet infos = ContainerUtil.newLinkedHashSet();
                this.runBeforeStartingCompile(project, (ProgressIndicator)indicator, compilerService);
                TypeScriptServiceCommandClean command = new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(config2));
                compilerService.sendCleanCommandToCompiler(command);
                this.compileConfig((ProgressIndicator)indicator, compilerService, config2, infos);
                this.logErrors(project, (Collection<JSAnnotationError>)infos);
            };
        }
        VirtualFile[] files = this.getFiles(project, context);
        return indicator -> this.runCompile(project, (ProgressIndicator)indicator, files);
    }

    @Override
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<VirtualFile> processor, @Nullable VirtualFile[] files) {
        if (project == null) {
            return;
        }
        if (files == null) {
            return;
        }
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
                index.iterateContentUnderDirectory(file, descendant -> {
                    if (!descendant.isDirectory() && TypeScriptCompilerSettings.acceptFileType(descendant.getFileType())) {
                        return processor.process((Object)descendant);
                    }
                    return true;
                });
                continue;
            }
            if (!processor.process((Object)file)) break;
        }
    }

    @Nullable
    protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
        VirtualFile file = TypeScriptCompileCurrentAction.getCurrentFile(dataContext);
        if (file != null) {
            return new VirtualFile[]{file};
        }
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
    }

    @Nullable
    private static VirtualFile getTypeScriptConfigVirtualFile(@Nullable DataContext context) {
        if (context == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null) {
            return null;
        }
        return "tsconfig.json".equals(file.getName()) ? file : null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileCurrentAction", "update"));
        }
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VirtualFile configVirtualFile = TypeScriptCompileCurrentAction.getTypeScriptConfigVirtualFile(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(configVirtualFile != null);
    }
}

