/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDocumentationProvider
extends JSDocumentationProvider {
    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, StringBuilder result) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendVariableInitializer"));
        }
        String text = variable.getLiteralOrReferenceInitializerText();
        if (text != null) {
            super.appendVariableInitializer(variable, result);
        }
    }

    @Override
    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, PsiElement originalElement, StringBuilder result) {
        JSTypeSubstitutor substitutor;
        String generics;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendClassAttributesAndName"));
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            this.appendAttrList((JSAttributeListOwner)jsClass, result);
            result.append("type ");
            result.append(jsClass.getName());
        } else {
            super.appendClassAttributesAndName(jsClass, originalElement, result);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (generics = TypeScriptDocumentationProvider.getGenerics((TypeScriptTypeParameterListOwner)jsClass, substitutor = this.getTypeSubstitutor((JSElement)jsClass, originalElement))) != null) {
            result.append(generics);
        }
    }

    @Override
    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, String packageName, StringBuilder result) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendClassExtendsAndImplements"));
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            return;
        }
        super.appendClassExtendsAndImplements(jsClass, packageName, result);
    }

    @Override
    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getVariableOrFieldType"));
        }
        return JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)variable);
    }

    @Override
    @NotNull
    protected String getFunctionPrefix(@NotNull JSFunction function, boolean get, boolean set) {
        JSClass jsClass;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionPrefix"));
        }
        if (!get && !set && (jsClass = JSUtils.getMemberContainingClass((PsiElement)function)) != null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionPrefix"));
            }
            return "";
        }
        String string = super.getFunctionPrefix(function, get, set);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionPrefix"));
        }
        return string;
    }

    @Override
    protected void appendAttrList(JSAttributeListOwner owner, StringBuilder result) {
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            String ns = JSResolveUtil.getNamespaceValue(attributeList);
            if (ns == null) {
                JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
                if (jsClass != null) {
                    ns = JSFormatUtil.formatVisibility(type, (PsiElement)owner);
                } else if (owner instanceof JSQualifiedNamedElement) {
                    if (((JSQualifiedNamedElement)owner).isExported()) {
                        ns = "export";
                    } else if (((JSQualifiedNamedElement)owner).isExportedWithDefault()) {
                        ns = "export default";
                    }
                }
            }
            if (ns != null) {
                result.append(ns);
                result.append(" ");
            }
            TypeScriptDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.STATIC);
            TypeScriptDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.READONLY);
        }
    }

    @Override
    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getVarPrefix"));
        }
        if (variable instanceof TypeScriptField || variable instanceof JSParameter) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getVarPrefix"));
            }
            return "";
        }
        String string = super.getVarPrefix(variable);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getVarPrefix"));
        }
        return string;
    }

    @Override
    protected void appendParentInfo(@Nullable PsiElement parent, @NotNull StringBuilder builder, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendParentInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendParentInfo"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendParentInfo"));
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            parent = JSUtils.getMemberContainingClass((PsiElement)element);
        }
        if (parent instanceof TypeScriptInterfaceClass && (generics = TypeScriptDocumentationProvider.getGenerics((TypeScriptTypeParameterListOwner)parent, substitutor)) != null) {
            String className = StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"class");
            builder.append(className);
            builder.append(generics);
            builder.append("\n");
            return;
        }
        super.appendParentInfo(parent, builder, element, substitutor);
    }

    @Override
    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @NotNull StringBuilder result, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendFunctionAttributesAndName"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendFunctionAttributesAndName"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendFunctionAttributesAndName"));
        }
        super.appendFunctionAttributesAndName(function, result, substitutor);
        if (function instanceof TypeScriptTypeParameterListOwner && (generics = TypeScriptDocumentationProvider.getGenerics((TypeScriptTypeParameterListOwner)function, substitutor)) != null) {
            result.append(generics);
        }
    }

    @Nullable
    private static String getGenerics(@NotNull TypeScriptTypeParameterListOwner owner, @NotNull JSTypeSubstitutor substitutor) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getGenerics"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getGenerics"));
        }
        TypeScriptTypeParameterList list = owner.getTypeParameterList();
        if (list == null) {
            return null;
        }
        Object[] parameters = list.getTypeParameters();
        if (parameters.length == 0) {
            return null;
        }
        StringBuilder newBuilder = new StringBuilder();
        newBuilder.append("<");
        newBuilder.append(StringUtil.join((Object[])parameters, el -> {
            JSType type;
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "lambda$getGenerics$0"));
            }
            String name = el.getName();
            if (name == null) {
                name = "?";
            }
            return (type = (JSType)substitutor.get((Object)name)) == null ? name : type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }, (String)","));
        newBuilder.append(">");
        return StringUtil.escapeXml((String)newBuilder.toString());
    }

    @Override
    protected void appendParameterDoc(@NotNull StringBuilder builder, @NotNull JSParameter parameter) {
        JSType type;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendParameterDoc"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendParameterDoc"));
        }
        if (!DumbService.isDumb((Project)parameter.getProject()) && (type = JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)parameter)) != null && !(type instanceof JSAnyType)) {
            builder.append("* ");
            builder.append("@param ");
            builder.append("{");
            builder.append(this.getTypeTextForGenerateDoc(type));
            builder.append("} ");
            builder.append(parameter.getName());
            return;
        }
        super.appendParameterDoc(builder, parameter);
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getTypeSubstitutor"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getTypeSubstitutor"));
        }
        if (TypeScriptDocumentationProvider.isElementFromTSSources(member, originalElement = TypeScriptDocumentationProvider.getOriginalElementOrParent(originalElement))) {
            member = TypeScriptDocumentationProvider.getOriginalResolvedElement(member, (JSReferenceExpression)originalElement);
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForMember(member, originalElement);
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getTypeSubstitutor"));
        }
        return jSTypeSubstitutor;
    }

    @Contract(value="!null->!null")
    private static PsiElement getOriginalElementOrParent(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement && JSKeywordSets.IDENTIFIER_NAMES.contains(originalElement.getNode().getElementType())) {
            originalElement = originalElement.getParent();
        }
        return originalElement;
    }

    @Override
    protected void appendVariableOrFieldType(@NotNull JSFieldVariable variableOrField, @Nullable PsiElement originalElement, @NotNull StringBuilder result, @NotNull JSTypeSubstitutor substitutor) {
        if (variableOrField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableOrField", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendVariableOrFieldType"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendVariableOrFieldType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "appendVariableOrFieldType"));
        }
        JSType definedType = variableOrField.getType();
        if (variableOrField instanceof JSVariable) {
            String name = variableOrField.getName();
            originalElement = TypeScriptDocumentationProvider.getOriginalElementOrParent(originalElement);
            if (name != null && originalElement instanceof JSReferenceExpression && ((JSReferenceExpression)originalElement).getQualifier() == null) {
                String narrowTypeForDocumentation;
                String definedTypeDocumentation;
                JSType narrowType;
                JSTypeEvaluationResult type = JSTypeEvaluator.getExpressionType((JSExpression)originalElement);
                JSType jSType = narrowType = type != null ? type.getType() : null;
                if (narrowType != null && narrowType != definedType && !StringUtil.equals((CharSequence)(definedTypeDocumentation = this.getTypeTextForQuickNavigate(definedType, substitutor)), (CharSequence)(narrowTypeForDocumentation = this.getTypeTextForQuickNavigate(narrowType, substitutor)))) {
                    this.appendType((PsiElement)variableOrField, result, narrowTypeForDocumentation);
                    if (!StringUtil.isEmpty((String)definedTypeDocumentation)) {
                        result.append(" <i>(").append(StringUtil.escapeXml((String)definedTypeDocumentation)).append(")</i>");
                    }
                    return;
                }
            }
        }
        super.appendVariableOrFieldType(variableOrField, originalElement, result, substitutor);
    }

    private static boolean isElementFromTSSources(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "isElementFromTSSources"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "isElementFromTSSources"));
        }
        return originalElement instanceof JSReferenceExpression && Boolean.TRUE.equals(TypeScriptDeclarationMappings.SOURCE_FILE_MARKER.get((UserDataHolder)member));
    }

    @Override
    @Nullable
    protected JSType getFunctionReturnTypeForInfoDoc(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getFunctionReturnTypeForInfoDoc"));
        }
        if (function instanceof TypeScriptFunction && function.getReturnTypeElement() != null) {
            return function.getReturnType();
        }
        return super.getFunctionReturnTypeForInfoDoc(function);
    }

    @Override
    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getTypeTextForQuickNavigate"));
        }
        rawType = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)el -> JSCompositeTypeImpl.optimizeTypeIfComposite(el)));
        return super.getTypeTextForQuickNavigate(rawType, substitutor);
    }

    @Override
    @NotNull
    protected String getTypeTextForGenerateDoc(@NotNull JSType rawType) {
        if (rawType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawType", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getTypeTextForGenerateDoc"));
        }
        rawType = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)el -> JSCompositeTypeImpl.optimizeTypeIfComposite(el)));
        String string = super.getTypeTextForGenerateDoc(rawType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getTypeTextForGenerateDoc"));
        }
        return string;
    }

    @NotNull
    private static JSElement getOriginalResolvedElement(@NotNull JSElement member, @NotNull JSReferenceExpression originalElement) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getOriginalResolvedElement"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getOriginalResolvedElement"));
        }
        ResolveResult[] results = originalElement.multiResolve(false);
        Collection<PsiElement> resolvedElements = JSResolveResult.toElements(results);
        if (resolvedElements.size() != 1) {
            JSElement jSElement = member;
            if (jSElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getOriginalResolvedElement"));
            }
            return jSElement;
        }
        PsiElement candidate = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        if (candidate instanceof JSElement) {
            member = (JSElement)candidate;
        }
        JSElement jSElement = member;
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider", "getOriginalResolvedElement"));
        }
        return jSElement;
    }
}

