/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.psi.impl.TypeScriptModuleTextReference;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPatternModuleReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        PsiReference[] psiReferenceArray = TypeScriptPatternModuleReferenceContributor.getReferences(unquotedRefText, host, offset, provider, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = TypeScriptPatternModuleReferenceContributor.getReferences(unquotedRefText, host, offset, provider, false);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider, boolean isCommonJS) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "getReferences"));
        }
        String requiredModuleName = FileUtilRt.toSystemIndependentName((String)unquotedRefText);
        final boolean isSoft = isCommonJS || !DialectDetector.isTypeScript(host);
        return new PsiReference[]{new TypeScriptModuleTextReference(host, requiredModuleName, offset){

            @Override
            public boolean isSoft() {
                return isSoft;
            }

            @Override
            protected ResolveResult[] doResolve(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor$1", "doResolve"));
                }
                return TypeScriptUtil.findPatternBasedExternalModule(psiFile.getOriginalFile(), this.getCanonicalText(), this.myElement.getProject());
            }

            @Override
            public int getWeight() {
                return JSModuleBaseReference.ModuleTypes.TS_PATTERN_MODULE.weight();
            }
        }};
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPatternModuleReferenceContributor", "isApplicable"));
        }
        return true;
    }
}

