/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGlobalQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptClassResolver
extends JSClassResolver {
    private static final CachedValueProvider<Map<String, Collection<JSQualifiedNamedElement>>> PROVIDER = () -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    private static final Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> CACHE_KEY = Key.create((String)"ts.class.resolve");
    private static TypeScriptClassResolver INSTANCE = null;

    protected TypeScriptClassResolver() {
    }

    public static TypeScriptClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptClassResolver();
        }
        return INSTANCE;
    }

    @Override
    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findClassByQName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findClassByQName"));
        }
        return this.findClassByQName(link, JavaScriptIndex.getInstance(context.getProject()), JSResolveUtil.getResolveScope(context), DialectOptionHolder.TS);
    }

    public static boolean isObjectInterface(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "isObjectInterface"));
        }
        return "Object".equals(clazz.getQualifiedName());
    }

    @Override
    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findClassesByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findClassesByQName"));
        }
        Project project = scope.getProject();
        assert (project != null);
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class);
        SmartList classes = new SmartList();
        for (Object _clazz : candidates) {
            JSClass clazz;
            if (!(_clazz instanceof JSClass) || !qName.equals((clazz = (JSClass)_clazz).getQualifiedName())) continue;
            classes.add((Object)clazz);
        }
        SmartList smartList = classes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findClassesByQName"));
        }
        return smartList;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQNameAndPlace(@NotNull String qName, @NotNull PsiElement place) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findElementsByQNameAndPlace"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findElementsByQNameAndPlace"));
        }
        PsiNamedElement parentOfType = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{JSFile.class, TypeScriptModule.class});
        if (parentOfType != null) {
            Map cachedValues = (Map)CachedValuesManager.getManager((Project)place.getProject()).getCachedValue((UserDataHolder)parentOfType, CACHE_KEY, PROVIDER, false);
            Collection<JSQualifiedNamedElement> elements = (Collection<JSQualifiedNamedElement>)cachedValues.get(qName);
            if (elements == null) {
                elements = this.findElementsByQName(qName, JSResolveUtil.getResolveScope((PsiElement)parentOfType));
                cachedValues.put(qName, elements);
            }
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findElementsByQNameAndPlace"));
            }
            return collection;
        }
        Collection<JSQualifiedNamedElement> collection = this.findElementsByQName(qName, JSResolveUtil.getResolveScope(place));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findElementsByQNameAndPlace"));
        }
        return collection;
    }

    @Override
    public boolean processElementByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "processElementByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "processElementByQName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "processElementByQName"));
        }
        scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scope, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        return super.processElementByQName(qName, scope, processor);
    }

    public Collection<JSPsiElementBase> findChildren(@NotNull String qName, @NotNull PsiElement place) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findChildren"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findChildren"));
        }
        GlobalSearchScope baseScope = JSResolveUtil.getResolveScope(place);
        final Project project = place.getProject();
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(baseScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver$1", "contains"));
                }
                if (!super.contains(file)) {
                    return false;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                return !(psiFile instanceof JSFile) || !((JSFile)psiFile).isCommonJSModule();
            }
        };
        return this.findNamespaceMembers(qName, (GlobalSearchScope)scope);
    }

    @Override
    protected PsiElement doFindClassByQName(@NotNull String link, JavaScriptIndex index, GlobalSearchScope searchScope, boolean allowFileLocalSymbols, @NotNull DialectOptionHolder dialect) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "doFindClassByQName"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "doFindClassByQName"));
        }
        return null;
    }

    @Nullable
    public JSClass findAnyClassByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findAnyClassByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findAnyClassByQName"));
        }
        List<JSClass> classes = this.findClassesByQName(qName, scope);
        return classes.isEmpty() ? null : (JSClass)classes.iterator().next();
    }

    @NotNull
    public List<JSClass> findObjectClasses(JSClass scopeElement) {
        List<JSClass> list = this.findClassesByQName("Object", JSResolveUtil.getResolveScope((PsiElement)scopeElement));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findObjectClasses"));
        }
        return list;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findGlobalElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findGlobalElementsByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findGlobalElementsByQName"));
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processGlobalElementsByQName(qName, scope, (Processor<? super JSQualifiedNamedElement>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "findGlobalElementsByQName"));
        }
        return collection;
    }

    public boolean processGlobalElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "processGlobalElementsByQName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "processGlobalElementsByQName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver", "processGlobalElementsByQName"));
        }
        return StubIndex.getInstance().processElements(JSGlobalQualifiedElementIndex.KEY, (Object)qName.hashCode(), scope.getProject(), scope, JSQualifiedNamedElement.class, processor);
    }
}

