/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptIncludeGeneratedDeclarationFilesAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || !this.isFileExclude(e)) {
            return;
        }
        TypeScriptGeneratedFilesManager manager = TypeScriptGeneratedFilesManager.getInstance(project);
        if (manager == null) {
            return;
        }
        manager.setExcludeDeclarationFiles(false);
        manager.updateProject();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/settings/exclude/TypeScriptIncludeGeneratedDeclarationFilesAction", "update"));
        }
        e.getPresentation().setEnabledAndVisible(this.isFileExclude(e));
    }

    @Nullable
    private static VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/settings/exclude/TypeScriptIncludeGeneratedDeclarationFilesAction", "getFile"));
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        DataContext context = e.getDataContext();
        return (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
    }

    private boolean isFileExclude(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/settings/exclude/TypeScriptIncludeGeneratedDeclarationFilesAction", "isFileExclude"));
        }
        Project project = e.getProject();
        VirtualFile file = TypeScriptIncludeGeneratedDeclarationFilesAction.getFile(e);
        if (file == null) {
            return false;
        }
        if (!file.getName().endsWith(this.getFileExtension())) {
            return false;
        }
        assert (project != null);
        TypeScriptGeneratedFilesManager manager = TypeScriptGeneratedFilesManager.getInstance(project);
        if (manager == null || !manager.isExcludeDeclarationFiles()) {
            return false;
        }
        Collection<String> paths = manager.getExcludedPaths();
        return !paths.isEmpty() && ContainerUtil.newHashSet(paths).contains(file.getCanonicalPath());
    }

    @NotNull
    protected String getFileExtension() {
        if (".d.ts" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptIncludeGeneratedDeclarationFilesAction", "getFileExtension"));
        }
        return ".d.ts";
    }
}

