/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dom;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XHTMLIncompatabilitiesJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("xhtml.incompatibilities.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dom/XHTMLIncompatabilitiesJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.DOM_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dom/XHTMLIncompatabilitiesJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("xhtml.incompatabilities.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression referenceExpression) {
            super.visitJSReferenceExpression(referenceExpression);
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            if (!"document".equalsIgnoreCase(qualifierText)) {
                return;
            }
            String methodName = referenceExpression.getReferencedName();
            if (!("images".equalsIgnoreCase(methodName) || "body".equalsIgnoreCase(methodName) || "applets".equalsIgnoreCase(methodName) || "links".equalsIgnoreCase(methodName) || "forms".equalsIgnoreCase(methodName) || "anchors".equalsIgnoreCase(methodName))) {
                return;
            }
            this.registerError((PsiElement)referenceExpression);
        }
    }
}

