/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import java.util.EnumSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ByteOrderMarkDetector
extends ResourceXmlDetector
implements Detector.JavaPsiScanner,
Detector.GradleScanner {
    public static final Issue BOM = Issue.create("ByteOrderMark", "Byte order mark inside files", "Lint will flag any byte-order-mark (BOM) characters it finds in the middle of a file. Since we expect files to be encoded with UTF-8 (see the EnforceUTF8 issue), the BOM characters are not necessary, and they are not handled correctly by all tools. For example, if you have a BOM as part of a resource name in one particular translation, that name will not be considered identical to the base resource's name and the translation will not be used.", Category.I18N, 8, Severity.FATAL, new Implementation(ByteOrderMarkDetector.class, EnumSet.of(Scope.MANIFEST, new Scope[]{Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.GRADLE_FILE, Scope.PROPERTY_FILE, Scope.PROGUARD_FILE}), Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.GRADLE_SCOPE, Scope.PROPERTY_SCOPE, Scope.PROGUARD_SCOPE)).addMoreInfo("http://en.wikipedia.org/wiki/Byte_order_mark");

    @Override
    public void beforeCheckFile(Context context) {
        CharSequence source = context.getContents();
        if (source == null) {
            return;
        }
        int max = source.length();
        for (int i = 1; i < max; ++i) {
            JavaContext javaContext;
            PsiJavaFile file;
            char c = source.charAt(i);
            if (c != '\ufeff') continue;
            Location location = Location.create(context.file, source, i, i + 1);
            String message = "Found byte-order-mark in the middle of a file";
            if (context instanceof XmlContext) {
                XmlContext xmlContext = (XmlContext)context;
                Node leaf = xmlContext.getParser().findNodeAt(xmlContext, i);
                if (leaf != null) {
                    xmlContext.report(BOM, leaf, location, message);
                    continue;
                }
            } else if (context instanceof JavaContext && (file = (javaContext = (JavaContext)context).getJavaFile()) != null) {
                PsiElement closest = javaContext.getParser().findElementAt(javaContext, i);
                if (closest == null && file.getClasses().length > 0) {
                    closest = file.getClasses()[0];
                }
                if (closest != null) {
                    javaContext.report(BOM, closest, location, message);
                    continue;
                }
            }
            context.report(BOM, location, message);
        }
    }

    @Override
    public void visitDocument(XmlContext context, Document document) {
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new JavaElementVisitor(){};
    }

    @Override
    public void run(Context context) {
    }
}

