/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyFindUsagesHandler;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.highlighting.jam.SpringAutowiredBeanFindUsagesHandler;
import com.intellij.spring.model.highlighting.jam.SpringJavaBeanReferencesFindUsagesHandler;
import com.intellij.spring.model.highlighting.jam.SpringJavaExternalBeanFindUsagesHandler;
import com.intellij.spring.model.properties.SpringPropertiesUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class SpringFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/SpringFindUsagesHandlerFactory", "canFindUsages"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return false;
        }
        if (SpringFacet.getInstance((Module)module) == null) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile instanceof XmlFile) {
            return SpringDomUtils.isSpringXml((XmlFile)((XmlFile)containingFile));
        }
        return this.isContextBeanCandidate(psiElement) || this.isExternalBean(psiElement);
    }

    private boolean isExternalBean(PsiElement psiElement) {
        return psiElement instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiElement), Collections.singleton("org.springframework.config.java.annotation.ExternalBean"));
    }

    private boolean isContextBeanCandidate(PsiElement psiElement) {
        return psiElement instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiElement), Collections.singleton("org.springframework.context.annotation.Bean"));
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/SpringFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (this.isContextBeanCandidate(element)) {
            return new SpringAutowiredBeanFindUsagesHandler(element);
        }
        if (this.isExternalBean(element)) {
            return new SpringJavaExternalBeanFindUsagesHandler((PsiMethod)element);
        }
        BeanProperty property = SpringPropertiesUtil.getBeanProperty(element);
        if (property != null) {
            return new BeanPropertyFindUsagesHandler(property);
        }
        CommonSpringBean bean = (CommonSpringBean)DomUtil.findDomElement((PsiElement)element, DomSpringBean.class, (boolean)false);
        if (bean != null) {
            return new SpringJavaBeanReferencesFindUsagesHandler(bean);
        }
        return null;
    }
}

