/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.SpringBeanPointer;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;

public class SpringBeanClassMember
extends MemberChooserObjectBase
implements ClassMember {
    private final SpringBeanPointer mySpringBean;

    public SpringBeanClassMember(SpringBeanPointer springBean) {
        super(SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)springBean), SpringPresentationProvider.getSpringIcon((Object)springBean));
        this.mySpringBean = springBean;
    }

    public MemberChooserObject getParentNodeDelegate() {
        return new SpringFileMemberChooserObjectBase(this.getSpringBean().getContainingFile());
    }

    public SpringBeanPointer getSpringBean() {
        return this.mySpringBean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SpringBeanClassMember member = (SpringBeanClassMember)((Object)o);
        return !(this.mySpringBean != null ? !this.mySpringBean.equals(member.mySpringBean) : member.mySpringBean != null);
    }

    public int hashCode() {
        return this.mySpringBean != null ? this.mySpringBean.hashCode() : 0;
    }

    private static class SpringFileMemberChooserObjectBase
    extends PsiElementMemberChooserObject {
        public SpringFileMemberChooserObjectBase(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/model/actions/generate/SpringBeanClassMember$SpringFileMemberChooserObjectBase", "<init>"));
            }
            super((PsiElement)psiFile, psiFile.getName(), psiFile instanceof XmlFile ? SpringApiIcons.SpringConfig : SpringApiIcons.SpringJavaConfig);
        }
    }
}

