/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.ParentRefConverter;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentRefConverterImpl
extends ParentRefConverter {
    public SpringBeanPointer fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        CommonSpringModel model = this.getSpringModel(context);
        if (!(model instanceof XmlSpringModel)) {
            return null;
        }
        for (CommonSpringModel commonModel : ((XmlSpringModel)model).getDependencies()) {
            SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)commonModel, (String)s);
            if (bean == null) continue;
            return bean;
        }
        return null;
    }

    @NotNull
    public Collection<SpringBeanPointer> getVariants(ConvertContext context) {
        Collection collection = ParentRefConverterImpl.getVariants((ConvertContext)context, (boolean)true, (boolean)false, (List)this.getRequiredClasses(context), (CommonSpringModel)this.getSpringModel(context));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/ParentRefConverterImpl", "getVariants"));
        }
        return collection;
    }
}

