/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.UseExistingBeanFromOtherContextQuickFix;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseExistingBeanQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        String parseBeanId;
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider", "getQuickFixes"));
        }
        if (requiredClasses.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        GenericDomValue beanPointer = (GenericDomValue)context.getInvocationElement();
        String string = parseBeanId = beanId != null ? beanId : beanPointer.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)parseBeanId)) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        XmlFile file = context.getFile();
        SpringManager springManager = SpringManager.getInstance((Project)file.getProject());
        SpringModel currentFileModel = springManager.getSpringModelByFile((PsiFile)file);
        if (currentFileModel == null || currentFileModel.getFileSet() == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        Module module = context.getModule();
        if (module == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        SmartList fixes = new SmartList();
        Set springModels = springManager.getAllModels(module);
        block0: for (SpringModel model : springModels) {
            PsiClass beanClass;
            SpringBeanPointer beanByName;
            if (model.getFileSet() == null || (beanByName = SpringModelSearchers.findBean((CommonSpringModel)model, (String)parseBeanId)) == null || (beanClass = beanByName.getBeanClass()) == null) continue;
            for (PsiClassType requiredClass : requiredClasses) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)requiredClass.resolve(), (boolean)true)) continue;
                fixes.add(new UseExistingBeanFromOtherContextQuickFix(parseBeanId, beanByName.getContainingFile(), model.getFileSet()));
                continue block0;
            }
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider", "getQuickFixes"));
        }
        return smartList;
    }
}

