/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPublicFactoryMethodInspection
extends SpringBeanInspectionBase {
    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringPublicFactoryMethodInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringPublicFactoryMethodInspection", "getShortName"));
        }
        return "SpringPublicFactoryMethodInspection";
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringPublicFactoryMethodInspection", "checkBean"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringPublicFactoryMethodInspection", "checkBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringPublicFactoryMethodInspection", "checkBean"));
        }
        GenericAttributeValue springBeanFactoryMethod = springBean.getFactoryMethod();
        if (!DomUtil.hasXml((DomElement)springBeanFactoryMethod)) {
            return;
        }
        PsiMethod factoryMethod = (PsiMethod)springBeanFactoryMethod.getValue();
        if (factoryMethod != null && !factoryMethod.hasModifierProperty("public")) {
            holder.createProblem((DomElement)springBeanFactoryMethod, HighlightSeverity.WARNING, SpringBundle.message("method.must.be.public", factoryMethod.getName()));
        }
    }
}

