/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MakeVoidQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.MethodParametersRemovingFix;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/model/highlighting/jam/ScheduledMethodInspection;", "Lcom/intellij/codeInspection/BaseJavaLocalInspectionTool;", "()V", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "spring-core"})
public final class ScheduledMethodInspection
extends BaseJavaLocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)CollectionsKt.listOf((Object)"org.springframework.scheduling.annotation.Scheduled"))) {
            Collection collection;
            SmartList fixes = new SmartList();
            if (Intrinsics.areEqual((Object)PsiType.VOID, (Object)psiMethod.getReturnType()) ^ true) {
                fixes.add((Object)new MakeVoidQuickFix(null));
            }
            if (psiMethod.getParameterList().getParametersCount() > 0) {
                fixes.add((Object)new MethodParametersRemovingFix(psiMethod));
            }
            if (!(collection = (Collection)fixes).isEmpty()) {
                PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
                if (psiIdentifier != null) {
                    LocalQuickFix[] localQuickFixArray;
                    void $receiver$iv;
                    ProblemsHolder problemsHolder;
                    Collection it = collection = psiIdentifier;
                    ProblemsHolder $receiver = problemsHolder = new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly);
                    Collection collection2 = (Collection)fixes;
                    String string = SpringBundle.message("ScheduledMethodInspection.inspection.display.name", new Object[0]);
                    PsiElement psiElement = (PsiElement)it;
                    ProblemsHolder problemsHolder2 = $receiver;
                    void thisCollection$iv = $receiver$iv;
                    LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[thisCollection$iv.size()]);
                    if (localQuickFixArray2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                    problemsHolder2.registerProblem(psiElement, string, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
                    return problemsHolder.getResultsArray();
                }
            }
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }
}

