/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.properties;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.properties.PropertyReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReferenceSet
extends ReferenceSetBase<PropertyReference> {
    @Nullable
    private final PsiClass myBeanClass;
    private final GenericDomValue<List<BeanProperty>> myGenericDomValue;
    private final ConvertContext myContext;
    private final CommonSpringBean myBean;

    public PropertyReferenceSet(@NotNull PsiElement element, @Nullable PsiClass beanClass, @NotNull GenericDomValue<List<BeanProperty>> genericDomValue, ConvertContext context, CommonSpringBean bean) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/properties/PropertyReferenceSet", "<init>"));
        }
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/properties/PropertyReferenceSet", "<init>"));
        }
        super(element);
        this.myBeanClass = beanClass;
        this.myGenericDomValue = genericDomValue;
        this.myContext = context;
        this.myBean = bean;
    }

    @NotNull
    protected PropertyReference createReference(TextRange range, int index) {
        PropertyReference propertyReference = new PropertyReference(this, range, index);
        if (propertyReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReferenceSet", "createReference"));
        }
        return propertyReference;
    }

    @NotNull
    public PropertyReference[] getPsiReferences() {
        PropertyReference[] propertyReferenceArray = this.getReferences().toArray(new PropertyReference[this.getReferences().size()]);
        if (propertyReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/properties/PropertyReferenceSet", "getPsiReferences"));
        }
        return propertyReferenceArray;
    }

    public GenericDomValue<List<BeanProperty>> getGenericDomValue() {
        return this.myGenericDomValue;
    }

    @Nullable
    public PsiClass getBeanClass() {
        return this.myBeanClass;
    }

    public ConvertContext getContext() {
        return this.myContext;
    }

    public CommonSpringBean getBean() {
        return this.myBean;
    }
}

