/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.resources;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringResourcesUtilImpl
extends SpringResourcesUtil {
    @NonNls
    private static final String CLASSPATH_PREFIX = "classpath:";
    @NonNls
    private static final String CLASSPATH_PREFIX_ASTERISK = "classpath*:";
    @NonNls
    private static final String FILE_PREFIX = "file:";
    @NonNls
    private static final String HTTP_PREFIX = "http:";
    private static final Function<PsiFile, Collection<PsiFileSystemItem>> TEST_CONTEXT_EVALUATOR = file -> {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList(file.getContainingDirectory());
        }
        VirtualFile dir = file.getProject().getBaseDir();
        if (dir == null) {
            return Collections.emptyList();
        }
        PsiDirectory directory = file.getManager().findDirectory(dir);
        return ContainerUtil.createMaybeSingletonList((Object)directory);
    };

    private static FilePathReferenceProvider createFilePathReferenceProvider(final SpringResourcesBuilder builder) {
        return new FilePathReferenceProvider(builder.isEndingSlashNotAllowed()){

            protected FileReference createFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text) {
                if (!PatternFileReferenceSet.isAntPattern((String)text)) {
                    return new FileReference(referenceSet, range, index, text);
                }
                return new PatternFileReferenceSet.PatternFileReference(referenceSet, range, index, text, builder.getFilter());
            }

            protected boolean isPsiElementAccepted(PsiElement element) {
                return super.isPsiElementAccepted(element) && element instanceof PsiFileSystemItem && builder.getFilter().value((Object)((PsiFileSystemItem)element));
            }
        };
    }

    @NotNull
    public <V extends PsiFileSystemItem> Collection<V> getResourceItems(@NotNull SpringProperty property, @NotNull Condition<PsiFileSystemItem> filter) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "getResourceItems"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "getResourceItems"));
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        SpringPropertyUtils.processSpringValues((SpringProperty)property, (genericValue, s) -> {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "lambda$getResourceItems$0"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "lambda$getResourceItems$0"));
            }
            Object value = genericValue.getValue();
            if (value instanceof String) {
                Converter converter = WrappingConverter.getDeepestConverter((Converter)property.getValueAttr().getConverter(), (GenericDomValue)property.getValueAttr());
                value = converter.fromString(genericValue.getStringValue(), ConvertContextFactory.createConvertContext((DomElement)genericValue));
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (!(o instanceof PsiFileSystemItem) || !filter.value((Object)((PsiFileSystemItem)o))) continue;
                    result.add((PsiFileSystemItem)o);
                }
            }
            return true;
        });
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "getResourceItems"));
        }
        return linkedHashSet;
    }

    public <V extends PsiFileSystemItem> Collection<V> getResourceItems(PsiReference[] references, Condition<PsiFileSystemItem> filter) {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        FileReferenceSet curSet = null;
        for (PsiReference reference : references) {
            FileReferenceSet refSet;
            FileReferenceSet fileReferenceSet = refSet = reference instanceof FileReference ? ((FileReference)reference).getFileReferenceSet() : null;
            if (refSet != null) {
                if (refSet == curSet) continue;
                curSet = refSet;
                reference = refSet.getLastReference();
                if (reference == null) continue;
            }
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] resolveResults;
                for (ResolveResult resolveResult : resolveResults = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement psiElement = resolveResult.getElement();
                    if (!(psiElement instanceof PsiFileSystemItem) || !filter.value((Object)((PsiFileSystemItem)psiElement))) continue;
                    result.add((PsiFileSystemItem)psiElement);
                }
                continue;
            }
            PsiElement psiElement = reference.resolve();
            if (!(psiElement instanceof PsiFileSystemItem) || !filter.value((Object)((PsiFileSystemItem)psiElement))) continue;
            result.add((PsiFileSystemItem)psiElement);
        }
        return result;
    }

    public PsiReference[] getReferences(final @NotNull SpringResourcesBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "getReferences"));
        }
        PsiReference[] prefixedReferences = SpringResourcesUtilImpl.getPrefixedReferences(builder);
        if (prefixedReferences != null) {
            return prefixedReferences;
        }
        PatternFileReferenceSet set = new PatternFileReferenceSet(builder.getText(), builder.getElement(), builder.getOffset(), builder.isEndingSlashNotAllowed(), builder.getTemplateName()){

            protected boolean isSoft() {
                return builder.isSoft();
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return builder.getFilter();
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                Collection collection = super.computeDefaultContexts();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl$2", "computeDefaultContexts"));
                }
                return collection;
            }
        };
        if (builder.getCustomDefaultPathEvaluator() != null) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)builder.getCustomDefaultPathEvaluator());
        } else if (builder.isFromCurrent()) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> ContainerUtil.createMaybeSingletonList((Object)file.getContainingDirectory()));
        } else if (builder.isFromRoot()) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return (PsiReference[])ArrayUtil.append((Object[])set.getAllReferences(), (Object)((Object)new PrefixReference(builder)), PsiReference.class);
    }

    @Nullable
    private static PsiReference[] getPrefixedReferences(final SpringResourcesBuilder builder) {
        String text = builder.getText();
        if (StringUtil.isEmptyOrSpaces((String)text) || text.startsWith(HTTP_PREFIX)) {
            return new PsiReference[]{new PrefixReference(builder)};
        }
        if (text.startsWith(CLASSPATH_PREFIX)) {
            return SpringResourcesUtilImpl.getFilePathReferences(builder, CLASSPATH_PREFIX);
        }
        if (text.startsWith(CLASSPATH_PREFIX_ASTERISK)) {
            return SpringResourcesUtilImpl.getFilePathReferences(builder, CLASSPATH_PREFIX_ASTERISK);
        }
        if (text.startsWith(FILE_PREFIX)) {
            String str = text.substring(FILE_PREFIX.length());
            if (str.startsWith("/") || FileUtil.isAbsolute((String)str)) {
                return PsiReference.EMPTY_ARRAY;
            }
            PatternFileReferenceSet set = new PatternFileReferenceSet(str, builder.getElement(), FILE_PREFIX.length() + builder.getOffset(), builder.isEndingSlashNotAllowed(), builder.getTemplateName()){

                protected boolean isSoft() {
                    return builder.isSoft();
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return builder.getFilter();
                }
            };
            if (builder.getCustomDefaultPathEvaluator() != null) {
                set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)builder.getCustomDefaultPathEvaluator());
            } else {
                VirtualFile file;
                PsiFile psiFile = builder.getElement().getContainingFile();
                PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
                if (context != null) {
                    psiFile = context.getContainingFile();
                }
                boolean test = (file = psiFile.getVirtualFile()) != null && ProjectFileIndex.SERVICE.getInstance((Project)psiFile.getProject()).isInTestSourceContent(file);
                set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)(test ? TEST_CONTEXT_EVALUATOR : FileReferenceSet.ABSOLUTE_TOP_LEVEL));
            }
            return (PsiReference[])ArrayUtil.append((Object[])set.getAllReferences(), (Object)((Object)new PrefixReference(builder)), PsiReference.class);
        }
        return null;
    }

    private static PsiReference[] getFilePathReferences(SpringResourcesBuilder builder, @Nullable String prefix) {
        int offset;
        String text;
        if (prefix == null) {
            text = builder.getText();
            offset = builder.getOffset();
        } else {
            text = StringUtil.substringAfter((String)builder.getText(), (String)prefix);
            offset = builder.getOffset() + prefix.length();
        }
        return SpringResourcesUtilImpl.createFilePathReferenceProvider(builder).getReferencesByElement(builder.getElement(), text, offset, builder.isSoft(), builder.getModules());
    }

    public PsiReference[] getClassPathReferences(@NotNull SpringResourcesBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl", "getClassPathReferences"));
        }
        PsiReference[] prefixedReferences = SpringResourcesUtilImpl.getPrefixedReferences(builder);
        if (prefixedReferences != null) {
            return prefixedReferences;
        }
        return SpringResourcesUtilImpl.getFilePathReferences(builder, null);
    }

    @Nullable
    public String getResourceFileReferenceString(PsiFile resourceFile) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = resourceFile == null ? null : resourceFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)resourceFile.getProject()).findLogicalRoot(virtualFile);
        if (logicalRoot != null) {
            return CLASSPATH_PREFIX + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)logicalRoot.getVirtualFile(), (char)'/');
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)resourceFile.getProject()).getFileIndex();
        VirtualFile contentRoot = index.getContentRootForFile(virtualFile);
        if (contentRoot != null) {
            return FILE_PREFIX + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
        }
        return FILE_PREFIX + virtualFile.getPath();
    }

    private static class PrefixReference
    extends PsiReferenceBase<PsiElement> {
        private PrefixReference(SpringResourcesBuilder builder) {
            super(builder.getElement(), builder.isSoft());
            String text = builder.getText();
            int colonIdx = text.indexOf(58);
            if (colonIdx == -1) {
                colonIdx = text.length();
            }
            int offset = builder.getOffset();
            this.setRangeInElement(TextRange.create((int)offset, (int)(offset + colonIdx)));
        }

        public PsiElement resolve() {
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = new Object[]{LookupElementBuilder.create((String)SpringResourcesUtilImpl.CLASSPATH_PREFIX).bold(), LookupElementBuilder.create((String)SpringResourcesUtilImpl.CLASSPATH_PREFIX_ASTERISK).bold(), LookupElementBuilder.create((String)SpringResourcesUtilImpl.FILE_PREFIX).bold(), LookupElementBuilder.create((String)SpringResourcesUtilImpl.HTTP_PREFIX).bold()};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/resources/SpringResourcesUtilImpl$PrefixReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

