/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomFileElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringUpdateSchemaIntention
implements IntentionAction {
    @NonNls
    private static final String BEANS = "beans xmlns=\"http://www.springframework.org/schema/beans\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\"";

    @NotNull
    public String getText() {
        String string = SpringBundle.message("update.schema.intention", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "isAvailable"));
        }
        if (file instanceof XmlFile && !(file instanceof JspFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement psiElement = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlProlog.class) != null || PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlDoctype.class) != null) {
                return SpringUpdateSchemaIntention.isUpdateNeeded((XmlFile)file);
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
            if (tag != null && tag.getParentTag() == null) {
                return SpringUpdateSchemaIntention.isUpdateNeeded((XmlFile)file);
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "invoke"));
        }
        SpringUpdateSchemaIntention.updateSchema((XmlFile)file);
    }

    public static boolean requestSchemaUpdate(@NotNull XmlFile file) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "requestSchemaUpdate"));
        }
        if (!SpringUpdateSchemaIntention.isUpdateNeeded(file)) {
            return true;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && Messages.showYesNoDialog((String)SpringBundle.message("xml.schema.will.be.updated", new Object[0]), (String)SpringBundle.message("xml.schema.update.is.required", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return false;
        }
        SpringUpdateSchemaIntention.updateSchema(file);
        return true;
    }

    private static void updateSchema(@NotNull XmlFile file) throws IncorrectOperationException {
        XmlDoctype doctype;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "updateSchema"));
        }
        Project project = file.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = documentManager.getDocument((PsiFile)file);
        assert (doc != null);
        DomFileElement element = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
        assert (element != null);
        XmlTag tag = element.getRootTag();
        assert (tag != null);
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        assert (child != null);
        TextRange range = child.getTextRange();
        doc.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)BEANS);
        documentManager.commitDocument(doc);
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)tag, range.getStartOffset(), range.getStartOffset() + BEANS.length());
        SpringModelVisitor.visitBeans((SpringModelVisitor)new SpringModelVisitor(){

            protected boolean visitBean(CommonSpringBean bean) {
                Boolean value;
                if (bean instanceof SpringBean && (value = (Boolean)((SpringBean)bean).getSingleton().getValue()) != null) {
                    ((SpringBean)bean).getSingleton().undefine();
                    ((SpringBean)bean).getScope().setValue((Object)(value != false ? SpringBeanScope.SINGLETON_SCOPE : SpringBeanScope.PROTOTYPE_SCOPE));
                }
                return true;
            }
        }, (Beans)((Beans)element.getRootElement()));
        XmlProlog prolog = ((XmlDocument)ObjectUtils.assertNotNull((Object)file.getDocument())).getProlog();
        XmlDoctype xmlDoctype = doctype = prolog == null ? null : prolog.getDoctype();
        if (doctype != null) {
            doctype.delete();
        }
        UsageTrigger.trigger((String)"spring.SpringUpdateSchemaIntention");
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static boolean isUpdateNeeded(@NotNull XmlFile config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/spring/refactoring/SpringUpdateSchemaIntention", "isUpdateNeeded"));
        }
        XmlDocument document = config.getDocument();
        assert (document != null);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        return !tag.getNamespace().equals("http://www.springframework.org/schema/beans");
    }
}

