/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.schemas;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.XmlNamespaceIndex;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSchemaProvider
extends XmlSchemaProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.schemas.SpringSchemaProvider");
    private static final Key<CachedValue<Map<String, VirtualFile>>> SCHEMAS_BUNDLE_KEY = Key.create((String)"spring schemas");
    private static final CachedValueProvider.Result<Map<String, VirtualFile>> EMPTY_MAP_RESULT = new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    private static final Set<String> SKIP_NAMESPACE_URLS = ContainerUtil.immutableSet((Object[])new String[]{"http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema"});

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        PsiDirectory directory;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/schemas/SpringSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/spring/schemas/SpringSchemaProvider", "getSchema"));
        }
        if (SKIP_NAMESPACE_URLS.contains(url)) {
            return null;
        }
        if (module == null && (directory = baseFile.getParent()) != null) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        }
        if (module == null) {
            return null;
        }
        Map<String, VirtualFile> schemas = SpringSchemaProvider.getSchemas(module);
        Project project = module.getProject();
        VirtualFile file = schemas.get(url);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        return (XmlFile)psiFile;
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/schemas/SpringSchemaProvider", "isAvailable"));
        }
        boolean isSpring = SpringDomUtils.isSpringXml((XmlFile)file);
        if (isSpring) {
            return true;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String extension = virtualFile.getExtension();
        return extension != null && extension.equals("xsd");
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, String tagName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/schemas/SpringSchemaProvider", "getAvailableNamespaces"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "getAvailableNamespaces"));
            }
            return set;
        }
        Map<String, VirtualFile> map = SpringSchemaProvider.getSchemas(module);
        HashSet strings = new HashSet(map.size());
        for (VirtualFile virtualFile : map.values()) {
            String namespace = SpringSchemaProvider.getNamespace(virtualFile, file.getProject());
            ContainerUtil.addIfNotNull(strings, (Object)namespace);
        }
        Set filtered = DefaultXmlExtension.filterNamespaces(strings, (String)tagName, (XmlFile)file);
        if (SpringDomUtils.isSpringXml((XmlFile)file)) {
            filtered.add("http://www.springframework.org/schema/c");
            filtered.add("http://www.springframework.org/schema/p");
        }
        Set set = filtered;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "getAvailableNamespaces"));
        }
        return set;
    }

    @Nullable
    private static String getNamespace(VirtualFile virtualFile, Project project) {
        PsiMetaData metaData;
        XmlDocument document;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && (metaData = document.getMetaData()) instanceof XmlNSDescriptorImpl) {
            return ((XmlNSDescriptorImpl)metaData).getDefaultNamespace();
        }
        return null;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/schemas/SpringSchemaProvider", "getDefaultPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/schemas/SpringSchemaProvider", "getDefaultPrefix"));
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)context)) {
            return null;
        }
        String[] strings = namespace.split("/");
        return strings[strings.length - 1];
    }

    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/schemas/SpringSchemaProvider", "getLocations"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/schemas/SpringSchemaProvider", "getLocations"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return null;
        }
        Map<String, VirtualFile> schemas = SpringSchemaProvider.getSchemas(module);
        String best = null;
        for (Map.Entry<String, VirtualFile> entry : schemas.entrySet()) {
            String s;
            String location = entry.getKey();
            if (!location.endsWith(".xsd") || (s = SpringSchemaProvider.getNamespace(entry.getValue(), context.getProject())) == null || !s.equals(namespace)) continue;
            if (!Character.isDigit(location.charAt(location.length() - ".xsd".length() - 1))) {
                return Collections.singleton(location);
            }
            if (best != null && location.compareTo(best) <= 0) continue;
            best = location;
        }
        return best == null ? Collections.emptySet() : Collections.singleton(best);
    }

    @NotNull
    private static Map<String, VirtualFile> getSchemas(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/schemas/SpringSchemaProvider", "getSchemas"));
        }
        Project project = module.getProject();
        Map bundle = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, SCHEMAS_BUNDLE_KEY, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/schemas/SpringSchemaProvider", "lambda$getSchemas$0"));
            }
            return SpringSchemaProvider.computeSchemas(module);
        }, false);
        Map map = bundle == null ? Collections.emptyMap() : bundle;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "getSchemas"));
        }
        return map;
    }

    @NotNull
    public static Map<String, String> getHandlers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/schemas/SpringSchemaProvider", "getHandlers"));
        }
        Map<String, String> map = SpringSchemaProvider.computeHandlers(module);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "getHandlers"));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static CachedValueProvider.Result<Map<String, VirtualFile>> computeSchemas(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/schemas/SpringSchemaProvider", "computeSchemas"));
        }
        List springSchemaFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)true, (String)"spring.schemas", PsiFile.class);
        if (springSchemaFiles.isEmpty()) {
            CachedValueProvider.Result<Map<String, VirtualFile>> result = EMPTY_MAP_RESULT;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "computeSchemas"));
            }
            return result;
        }
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        for (PsiFile springSchemaPsiFile : springSchemaFiles) {
            dependencies.add(springSchemaPsiFile);
            PsiDirectory parent = springSchemaPsiFile.getContainingDirectory().getParent();
            assert (parent != null);
            String root = parent.getVirtualFile().getUrl();
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            InputStream inputStream = null;
            try {
                VirtualFile schemasFile = springSchemaPsiFile.getVirtualFile();
                inputStream = schemasFile.getInputStream();
                PropertyResourceBundle bundle = new PropertyResourceBundle(inputStream);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String namespace;
                    int lastCharPos;
                    char lastChar;
                    String key = keys.nextElement();
                    String location = (String)bundle.handleGetObject(key);
                    String schemaUrl = root + location;
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(schemaUrl);
                    if (file == null) continue;
                    map.put(key, file);
                    if (!key.endsWith(".xsd") || Character.isDigit(lastChar = key.charAt(lastCharPos = key.length() - ".xsd".length() - 1)) || (namespace = XmlNamespaceIndex.getNamespace((VirtualFile)file, (Project)module.getProject(), null)) == null) continue;
                    map.put(namespace, file);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                CachedValueProvider.Result<Map<String, VirtualFile>> result = EMPTY_MAP_RESULT;
                CachedValueProvider.Result<Map<String, VirtualFile>> result2 = result;
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "computeSchemas"));
                }
                return result2;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        CachedValueProvider.Result result = new CachedValueProvider.Result(map, dependencies.toArray());
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "computeSchemas"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Map<String, String> computeHandlers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/schemas/SpringSchemaProvider", "computeHandlers"));
        }
        List springHandlerFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)true, (String)"spring.handlers", PsiFile.class);
        if (springHandlerFiles.isEmpty()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "computeHandlers"));
            }
            return map;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (PsiFile springHandlerFile : springHandlerFiles) {
            VirtualFile handlersFile = springHandlerFile.getVirtualFile();
            assert (handlersFile != null);
            InputStream inputStream = null;
            try {
                inputStream = handlersFile.getInputStream();
                PropertyResourceBundle bundle = new PropertyResourceBundle(inputStream);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    map.put(key, (String)bundle.handleGetObject(key));
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                Map<String, String> map2 = Collections.emptyMap();
                Map<String, String> map3 = map2;
                if (map3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "computeHandlers"));
                }
                return map3;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/schemas/SpringSchemaProvider", "computeHandlers"));
        }
        return hashMap;
    }
}

