/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.settings;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SpringGeneralSettingsUi
implements ConfigurableUi<SpringGeneralSettings> {
    private JPanel myRootPanel;
    private JBCheckBox myShowProfilesPanel;
    private JBCheckBox myShowMultiContextsPanel;

    SpringGeneralSettingsUi() {
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/settings/SpringGeneralSettingsUi", "reset"));
        }
        this.myShowProfilesPanel.setSelected(settings.isShowProfilesPanel());
        this.myShowMultiContextsPanel.setSelected(settings.isShowMultipleContextsPanel());
    }

    public boolean isModified(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/settings/SpringGeneralSettingsUi", "isModified"));
        }
        return this.hasModifiedEditorPanelSettings(settings);
    }

    private boolean hasModifiedEditorPanelSettings(@NotNull SpringGeneralSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/settings/SpringGeneralSettingsUi", "hasModifiedEditorPanelSettings"));
        }
        return settings.isShowProfilesPanel() != this.myShowProfilesPanel.isSelected() || settings.isShowMultipleContextsPanel() != this.myShowMultiContextsPanel.isSelected();
    }

    public void apply(@NotNull SpringGeneralSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/settings/SpringGeneralSettingsUi", "apply"));
        }
        if (this.hasModifiedEditorPanelSettings(settings)) {
            settings.setShowProfilesPanel(this.myShowProfilesPanel.isSelected());
            settings.setShowMultipleContextsPanel(this.myShowMultiContextsPanel.isSelected());
            EditorNotifications.updateAll();
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/settings/SpringGeneralSettingsUi", "getComponent"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Configuration Files Editor", (int)1, (int)0, null, null));
        this.myShowProfilesPanel = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show Profiles panel");
        jBCheckBox2.setMnemonic('P');
        jBCheckBox2.setDisplayedMnemonicIndex(5);
        jBCheckBox2.setToolTipText("Allow choosing active profile(s)");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowMultiContextsPanel = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show Multiple Contexts panel");
        jBCheckBox.setMnemonic('M');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        jBCheckBox.setToolTipText("Allow choosing active context if file is used in multiple contexts");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

