/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class HtmlHttpEquivEncodingReferenceProvider
extends XmlEncodingReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/htmltools/codeInsight/daemon/impl/analysis/encoding/HtmlHttpEquivEncodingReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/htmltools/codeInsight/daemon/impl/analysis/encoding/HtmlHttpEquivEncodingReferenceProvider", "getReferencesByElement"));
        }
        LOG.assertTrue(element instanceof XmlAttributeValue);
        XmlAttributeValue value = (XmlAttributeValue)element;
        PsiElement parent = value.getParent();
        if (parent instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)parent;
            XmlTag tag = attribute.getParent();
            String name = attribute.getLocalName();
            if (tag != null && "meta".equals(tag.getLocalName()) && tag.getAttribute("http-equiv") != null && name.equals("content")) {
                PsiReference[] psiReferenceArray = HtmlHttpEquivEncodingReferenceProvider.extractFromContentAttribute((XmlAttributeValue)value);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/codeInsight/daemon/impl/analysis/encoding/HtmlHttpEquivEncodingReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/codeInsight/daemon/impl/analysis/encoding/HtmlHttpEquivEncodingReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

