/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.xml.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.UserColorLookup;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorReference
extends BasicAttributeValueReference {
    @NonNls
    static final HashSet<String> ourBgColorTagNames = new HashSet<String>(Arrays.asList("body", "td", "tr", "table", "th"));
    private static Object[] ourValues;
    @NonNls
    static final String BG_COLOR_ATTR_NAME = "bgcolor";
    @NonNls
    static final String COLOR_ATTR_NAME = "color";
    @NonNls
    static final String ALINK_ATTR_NAME = "alink";
    @NonNls
    static final String LINK_ATTR_NAME = "link";
    @NonNls
    static final String VLINK_ATTR_NAME = "vlink";
    @NonNls
    static final String TEXT_ATTR_NAME = "text";

    public ColorReference(PsiElement element, int offset) {
        super(element, offset);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myElement;
    }

    @NotNull
    public Object[] getVariants() {
        if (ourValues == null) {
            ColorSampleLookupValue[] colors = ColorSampleLookupValue.getColors();
            ourValues = new Object[colors.length + 1];
            System.arraycopy(colors, 0, ourValues, 0, colors.length);
            ColorReference.ourValues[colors.length] = new UserColorLookup();
        }
        if (ourValues == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/xml/util/ColorReference", "getVariants"));
        }
        return ourValues;
    }

    public boolean isSoft() {
        return true;
    }
}

