/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.xml.util;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.htmltools.xml.util.HtmlReferenceProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import org.intellij.images.index.ImageInfoIndex;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUpdateImageSizeIntention
extends BaseIntentionAction {
    private boolean myUseElementToTheLeft = false;

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"html.intentions.update.image.size", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention", "isAvailable"));
        }
        int offset = editor.getCaretModel().getOffset();
        if (this.isAvailable(HtmlUpdateImageSizeIntention.getTag(file, offset))) {
            return true;
        }
        if (offset > 0 && this.isAvailable(HtmlUpdateImageSizeIntention.getTag(file, offset - 1))) {
            this.myUseElementToTheLeft = true;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag) {
        if (tag == null) {
            return false;
        }
        ImageInfoIndex.ImageInfo imageInfo = HtmlUpdateImageSizeIntention.getImageInfo(tag);
        if (imageInfo == null || imageInfo.height == 0 || imageInfo.width == 0) {
            return false;
        }
        String widthValue = tag.getAttributeValue("width");
        String heightValue = tag.getAttributeValue("height");
        this.setText(widthValue != null || heightValue != null ? XmlBundle.message((String)"html.intentions.update.image.size", (Object[])new Object[0]) : XmlBundle.message((String)"html.intentions.insert.image.size", (Object[])new Object[0]));
        return imageInfo.width != HtmlReferenceProvider.SizeReference.getSizeValue(widthValue, (XmlElement)tag) || imageInfo.height != HtmlReferenceProvider.SizeReference.getSizeValue(heightValue, (XmlElement)tag);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        final XmlTag tag = HtmlUpdateImageSizeIntention.getTag(file, this.myUseElementToTheLeft ? offset - 1 : offset);
        if (tag == null) {
            return;
        }
        final ImageInfoIndex.ImageInfo imageInfo = HtmlUpdateImageSizeIntention.getImageInfo(tag);
        if (imageInfo != null && imageInfo.height != 0 && imageInfo.width != 0) {
            new WriteCommandAction<Void>(project, new PsiFile[]{file}){

                protected void run(@NotNull Result<Void> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention$1", "run"));
                    }
                    tag.setAttribute("width", String.valueOf(imageInfo.width));
                    tag.setAttribute("height", String.valueOf(imageInfo.height));
                }
            }.execute();
        }
    }

    @Nullable
    private static ImageInfoIndex.ImageInfo getImageInfo(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention", "getImageInfo"));
        }
        if ("img".equalsIgnoreCase(xmlTag.getName())) {
            return HtmlReferenceProvider.SizeReference.getImageInfo(xmlTag);
        }
        return null;
    }

    @Nullable
    private static XmlTag getTag(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention", "getTag"));
        }
        if (!HtmlUtil.hasHtml((PsiFile)file)) {
            return null;
        }
        return (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.getViewProvider().findElementAt(offset, (Language)HTMLLanguage.INSTANCE), (Class[])new Class[]{XmlTag.class});
    }
}

